package yukihane.inqubus.cookie;

import static org.apache.commons.lang.StringUtils.*;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * WindowsのChrome cookie ディレクトリを決め打ちして扱います.
 * @author rankingloid (nicorank)
 * @author hazychill (nicorank)
 * @author orz (saccubus)
 * @author yuki
 */
class CookieWinCrome extends Cookie {

    private static final Logger logger = LoggerFactory.getLogger(CookieWinCrome.class);
    private static final String COOKIE_PATH = "/Google/Chrome/User Data/Default/Cookies";

    /** <p>
     *  Chrome から user_session を取得。エラーが起こった場合、例外を投げずに空文字を返す
     *  </p>
     *  @return user_session
     */
    @Override
    protected String getNicoUserSession() throws IOException {
        final List<File> alters = new ArrayList<>();

        // Win7
        final String localAppData = System.getenv("LOCALAPPDATA");
        if (isNotEmpty(localAppData)) {
            alters.add(new File(localAppData + COOKIE_PATH));
        }

        // WinXP
        final String userProfile = System.getenv("USERPROFILE");
        if (isNotEmpty(userProfile)) {
            alters.add(new File(userProfile + "/Local Settings/Application Data" + COOKIE_PATH));
        }

        // ??? just try
        final String appData = System.getenv("APPDATA");
        if (isNotEmpty(appData)) {
            alters.add(new File(appData + COOKIE_PATH));
        }

        return getUserSession("UTF-8", alters.toArray(new File[0]));
    }
}
