package yukihane.inqubus.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import javax.swing.table.AbstractTableModel;
import yukihane.inqubus.manager.TaskKind;
import yukihane.inqubus.manager.TaskStatus;

/**
 *
 * @author yuki
 */
public class TargetsTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TargetsTableModel.class);
    private final List<Target> targets = new ArrayList<>();
    private static final int STATUS_CLOMN = 4;
    private final String[] columnNames = new String[]{"ID", "動画", "コメ", "変換", "状態"};
    private final Class<?>[] columnClasses = new Class<?>[]{String.class, Boolean.class, Boolean.class, Boolean.class,
        Progress.class};

    @Override
    public int getRowCount() {
        return targets.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Target t = targets.get(rowIndex);
        Object res;
        switch (columnIndex) {
            case 0:
                res = t.getVideoId();
                break;
            case 1:
                res = Boolean.valueOf(t.isVideoDownload());
                break;
            case 2:
                res = Boolean.valueOf(t.isCommentDownload());
                break;
            case 3:
                res = Boolean.valueOf(t.isConvert());
                break;
            case 4:
                res = t.getProgress();
                break;
            default:
                throw new IllegalArgumentException();
        }
        return res;
    }

    public void addTarget(Collection<Target> t) {
        int before = targets.size();
        targets.addAll(t);
        int after = targets.size();
        if (before < after) {
            fireTableRowsInserted(before, after - 1);
        }
    }

    public void addTarget(Target t) {
        List<Target> list = new ArrayList<>(1);
        list.add(t);
        addTarget(list);
    }

    public Target getTarget(int rowIndex) {
        return targets.get(rowIndex);
    }

    public void setStatus(int id, TaskKind taskKind, TaskStatus taskStatus, double percent, String status) {
        int pos = -1;
        for (int i = 0; i < targets.size(); i++) {
            final Target t = targets.get(i);
            final int ri = t.getRowId();
            if (id == ri) {
                pos = i;
                break;
            }
        }
        if (pos < 0) {
            logger.error("本来存在すべきレコードが存在しません id:{}", id);
            return;
        }

        final Target t = targets.get(pos);
        t.setProgress(taskKind, taskStatus, percent, status);
        fireTableCellUpdated(pos, STATUS_CLOMN);
    }
}
