/* $Id$ */
package yukihane;

import static yukihane.inqubus.InqubusConstants.*;

import java.util.regex.Matcher;

/**
 * nicobrowser.util.Utilより, 必要なものをピックアップしたクラス.
 * その後増えました.
 * @author yuki
 */
public final class Util {

    private Util() {
    }

    /**
     * Content-Type から拡張子を決定する.
     * @param contentType Content-Type文字列.
     * @return 推測される拡張子.
     */
    public static String getExtention(String contentType) {
        if ("video/flv".equals(contentType) || "video/x-flv".equals(contentType)) {
            return "flv";
        } else if ("video/mp4".equals(contentType)) {
            return "mp4";
        } else if ("application/x-shockwave-flash".equals(contentType)) {
            return "swf";
        }
        return contentType.split("/")[1];
    }

    public static String getVideoId(final String alterId) {
        final int startIdIdx = alterId.lastIndexOf("/") + 1;
        final String altId = alterId.substring(startIdIdx);
        final Matcher idMatcher = PATTERN_VIDEO_ID.matcher(altId);
        if (!idMatcher.find()) {
            throw new IllegalArgumentException("URL/IDの指定が不正です: " + alterId);
        }

        return idMatcher.group(1);
    }
}
