package saccubus.worker.profile;

import java.io.File;

/**
 *
 * @author yuki
 */
public interface ConvertProfile {

    OutputProfile getOutputProfile();

    GeneralProfile getGeneralProfile();

    FfmpegProfile getFfmpegOption();

    /** @return 動画変換処理を行う必要があればtrue. */
    boolean isConvert();

    /**
     * @return {@link #isConvert()}がtrueの場合に
     * 使用するffmpeg実行ファイル.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    File getFfmpeg();

    /**
     * @return {@link #isConvert()}がtrueの場合に
     * 拡張ライブラリを使用せずに変換を行うのであればtrue.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    boolean isVhookDisabled();

    /**
     * @return {@link #isConvert()}がtrueかつ{@link #isVhookDisabled()}がfalseの場合に
     * コメントを付与して変換を行うのであればtrue.
     * それ以外の場合は未定義.
     */
    boolean isCommentOverlay();

    /**
     * @return {@link #isConvert()}がtrueかつ{@link #isVhookDisabled()}がfalseの場合に
     * 使用する拡張ライブラリファイル.
     * それ以外の場合は未定義.
     */
    File getVhook();

    /**
     * @return {@link #isConvert()}がtrueの場合に
     * 使用するMediaInfo実行ファイル.
     * それ以外の場合は未定義.
     */
    File getMediaInfo();

    /** @return 一時作業ディレクトリ. */
    File getTempDir();

    /** @return 使用するフォントファイル. */
    File getFont();

    /** @return フォント番号. */
    int getFontIndex();

    /** @return 全てのコメントを不透明にするのであればtrue. */
    boolean isCommentOpaque();

    /** @return コメントのフォントサイズを自動調整するのであればfalse. */
    boolean isDisableFontSizeArrange();

    /** @return 影の種類 */
    int getShadowIndex();

    /** @return 変換中に変換中画像を画面に表示するのであればtrue. */
    boolean isShowConverting();

    /** @return 1画面中に表示する最大コメント数. 負値の場合は既定値(30)と同等. */
    int getMaxNumOfComment();

    HideCondition getNgSetting();

    /**
     *
     * @author yuki
     */
    public interface HideCondition {

        String getWord();

        String getId();
    }
}
