<?php
function pripre_publish_tool() {
    add_meta_box('pripre_publish_books_box', __('カテゴリと本', 'pripre_textdomain'), 'pripre_publish_books_box', 'pripre_publish', 'normal');
    if (isset($_GET['book_id'])) {
        add_meta_box('pripre_publish_book_box', __('本', 'pripre_textdomain'), 'pripre_publish_book_box', 'pripre_publish', 'normal');
    }
    
    do_meta_boxes('pripre_publish', 'normal');
}

function pripre_publish_books_box() {
    require_once ('utils.inc.php');

    global $wpdb;
    $sql = "SELECT b.id,b.book_date
            FROM {$wpdb->prefix}pripre_book AS b
            ORDER BY b.book_date DESC;";
    $rows = $wpdb->get_results($sql, ARRAY_A);
    $books = array();
    foreach($rows as $row) {
    	$books[] = $row['id'];
    }
    $cats = get_all_category_ids();
    $cats = array_diff($cats, $books);
    if (!empty($cats)) { ?>
<form action="<?php echo plugins_url('pripre/actions/add-book.php');?>" method="post" class="pripre_publish">
	<p>記事をカテゴリーごとに本にすることができます。</p>
    <label><span>本にしていないカテゴリー </span><select name="category">
    <?php foreach($cats as $cat) { ?>
        <option value="<?php echo $cat; ?>"><?php echo get_cat_name($cat); ?></option>
    <?php } ?>
    </select></label>
    <input type="submit" name="button" class="button-secondary" value="本にする"  />
</form>
<?php }
	if (!empty($rows)) { ?>
<form method="get" class="pripre_publish">
    <input type="hidden" name="page" value="pripre_publish_tool"/>
	<label><span>本にしたカテゴリー </span><select name="book_id">
    <?php
    foreach($rows as $row) {
    ?>
    <option value="<?php echo $row['id']; ?>"
    <?php if (isset($_GET['book_id']) && $_GET['book_id'] == $row['id']) { ?>
    selected="selected"
    <?php } ?>><?php echo get_cat_name($row['id']); ?></option>
    <?php
    }
    ?>
    </select></label>
    <input type="submit" name="button" class="button-secondary" value="選択"  />
</form>
<?php
	}
}

function pripre_publish_book_box() {
    require_once ('utils.inc.php');
    $book_id = (int)$_GET['book_id'];

    global $wpdb;

    $title = get_cat_name($book_id);
    
    $bind = pripre_get_bookparam($book_id, 'bind');
    $size = pripre_get_bookparam($book_id, 'size');
    $css = pripre_get_bookparam($book_id, 'css');
    $epubmeta = pripre_get_bookparam($book_id, 'epubmeta');
    $etamplate = pripre_get_bookparam($book_id, 'etemplate');
    
    $etemplates = pripre_get_etemplates();
    
    $sql = "SELECT p.post_date,p.id,p.post_title
            FROM {$wpdb->prefix}term_relationships AS t
            INNER JOIN {$wpdb->prefix}posts AS p ON p.id=t.object_id
            WHERE t.term_taxonomy_id=$book_id";
    $rows = $wpdb->get_results($sql, ARRAY_A);
    pripre_sort_bookposts($book_id, $rows);
    ?>
    <script type="text/javascript" src="<?php echo plugins_url('pripre/js/publish.js'); ?>"></script>
    <script type="text/javascript">var pripre_base = "<?php echo plugins_url('pripre'); ?>";</script>
    <form action="" method="post">
        <input id="pripre_book_id" type="hidden" name="book_id" value="<?php echo $book_id; ?>" />
        <h4>オプション</h4>
        <table class="form-table">
            <tr valign="top">
                <th>タイトル</th>
                <td><?php echo $title; ?></td>
            </tr>
            <tr valign="top">
                <th>綴じ方</th>
                <td><label><input id="pripre_bind_left" type="radio" name="bind" value="left"<?php if (empty($bind) || $bind == 'left') echo ' checked="checked"';?> onChange="pripre_update();"/>左綴じ</label>
                <label><input id="pripre_bind_right" type="radio" name="bind" value="right"<?php if ($bind == 'right') echo ' checked="checked"';?> onChange="pripre_update();"/>右綴じ</label></td>
            </tr>
            <tr valign="top">
                <th>追加CSS</th>
                <td><textarea name="css" cols="60" rows="6" onChange="pripre_update();" id="pripre_css"><?php echo htmlentities($css); ?></textarea></td>
            </tr>
        </table>
        <h4>内容</h4>
        <p>ドラッグ＆ドロップで並び替えることができます。
        <div id="pripre-book" class="pripre-list">
            <?php
            foreach($rows as $row) {
                ?>
                <div class="pripre-post-item pripre-in-book">
                    <div class="pripre-drop pripre-before"></div>
                    <span class="pripre-id"><?php echo $row['id']; ?></span>
                    <span class="pripre-date"><?php echo $row['post_date']; ?></span>
                    <a href="post.php?post=<?php echo $row['id']; ?>&amp;action=edit" target="_blank" class="pripre-title"><?php echo $row['post_title']; ?></a>
                    <div class="pripre-clear"></div>
                    <div class="pripre-drop pripre-after"></div>
                </div>
                <?php
            }
            ?>
        </div>
        <p class="pripre-submit">
            <input type="submit" class="button-secondary"
            onclick="form.action='<?php echo plugins_url('pripre/actions/delete-book.php'); ?>'; return 1;"
            value="この本を削除"/>
        </p>
        
        <h4>PDF</h4>
        <table class="form-table">
            <tr valign="top">
                <th>サイズ</th>
                <td><label><select id="pripre_size" name="size" onChange="pripre_update();">
                  <option value="46"<?php if ($size == '46'){ ?> selected="selected"<?php } ?>>四六判</option>
                  <option value="B6"<?php if ($size == 'B6'){ ?> selected="selected"<?php } ?>>B6判</option>
                  <option value="A5"<?php if ($size == 'A5'){ ?> selected="selected"<?php } ?>>A5判（教科書）</option>
                  <option value="A6"<?php if ($size == 'A6'){ ?> selected="selected"<?php } ?>>A6判（文庫）</option>
                  <option value="Shinsho"<?php if ($size == 'Shinsho'){ ?> selected="selected"<?php } ?>>新書判</option>
                </select></label></td>
            </tr>
        </table>
        <p class="pripre-submit">
            <input type="submit" name="submit" class="button-secondary"
            onclick="form.action='<?php plugins_url('pripre/actions/publish-pdf.php/book.pdf'); ?>'; return 1;"
            value="PDFをダウンロード"/>
        </p>
        
        <h4>EPUB</h4>
        <table class="form-table">
            <tr valign="top">
                <th>スタイル</th>
                <td>
                  <select name="etemplate" id="pripre_etemplate" onChange="pripre_update();">
                    <option value=""<?php if (empty($etamplate)) echo ' selected="selected"'; ?>>-書籍スタイル-</option>
                    <?php foreach ($etemplates as $etemplate) { ?>
                    <option value="<?php echo $etemplate['id']; ?>"<?php if ($etamplate == $etemplate['id']) echo ' selected="selected"'; ?>><?php echo $etemplate['name']; ?></option>
                    <?php } ?>
                  </select>
                </td>
            </tr>
            <tr valign="top">
                <th>メタデータ</th>
                <td><textarea name="epubmeta" cols="60" rows="6" onChange="pripre_update();" id="pripre_epubmeta"><?php echo htmlentities($epubmeta); ?></textarea></td>
            </tr>
        </table>
        <p class="pripre-submit">
            <input type="submit" name="submit" class="button-secondary"
            onclick="form.action='<?php echo plugins_url('pripre/actions/publish-epub.php/book.epub'); ?>'; return 1;"
            value="EPUBをダウンロード"/>
        </p>
    </form>
    <?php
}
?>
