/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;

public class DefaultReportImpl
implements Report {
    private String ePubName;
    private int errorCount;
    private int warningCount;
    private int exceptionCount;

    public DefaultReportImpl(String ePubName) {
        this.ePubName = ePubName;
        this.errorCount = 0;
        this.warningCount = 0;
        this.exceptionCount = 0;
    }

    public DefaultReportImpl(String ePubName, String info) {
        this.ePubName = ePubName;
        this.warning("", 0, 0, info);
        this.errorCount = 0;
        this.warningCount = 0;
        this.exceptionCount = 0;
    }

    private String fixMessage(String message) {
        if (message == null) {
            return "";
        }
        return message.replaceAll("[\\s]+", " ");
    }

    @Override
    public void error(String resource, int line, int column, String message) {
        ++this.errorCount;
        message = this.fixMessage(message);
        System.err.println("ERROR: " + this.ePubName + (resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void warning(String resource, int line, int column, String message) {
        ++this.warningCount;
        message = this.fixMessage(message);
        System.err.println("WARNING: " + this.ePubName + (resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void exception(String resource, Exception e) {
        ++this.exceptionCount;
        System.err.println("EXCEPTION: " + this.ePubName + (resource == null ? "" : "/" + resource) + e.getMessage());
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public int getExceptionCount() {
        return this.exceptionCount;
    }
}

