/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Archive {
    ArrayList<String> paths;
    ArrayList<String> names;
    File baseDir;
    File epubFile;
    String epubName;
    boolean deleteOnExit = true;

    public Archive(String base, boolean save) {
        this.deleteOnExit = !save;
        this.baseDir = new File(base);
        if (!this.baseDir.exists() || !this.baseDir.isDirectory()) {
            throw new RuntimeException("The path specified for the archive is invalid!");
        }
        this.epubName = this.baseDir.getName() + ".epub";
        this.epubFile = new File(this.epubName);
        if (this.deleteOnExit) {
            this.epubFile.deleteOnExit();
        }
        this.paths = new ArrayList();
        this.names = new ArrayList();
    }

    public Archive(String base) {
        this.baseDir = new File(base);
        if (!this.baseDir.exists() || !this.baseDir.isDirectory()) {
            throw new RuntimeException("The path specified for the archive is invalid!");
        }
        this.epubName = this.baseDir.getName() + ".epub";
        this.epubFile = new File(this.epubName);
        this.epubFile.deleteOnExit();
        this.paths = new ArrayList();
        this.names = new ArrayList();
    }

    public String getEpubName() {
        return this.epubName;
    }

    public File getEpubFile() {
        return this.epubFile;
    }

    public void deleteEpubFile() {
        this.epubFile.delete();
    }

    public void createArchive() {
        this.collectFiles(this.baseDir, "");
        byte[] buf = new byte[1024];
        try {
            int len;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.epubName));
            int index = this.names.indexOf("mimetype");
            if (index >= 0) {
                FileInputStream in = new FileInputStream(this.paths.get(index));
                ZipEntry entry = new ZipEntry(this.names.get(index));
                entry.setMethod(0);
                int size = 0;
                while ((len = in.read(buf)) > 0) {
                    size += len;
                }
                in = new FileInputStream(this.paths.get(index));
                entry.setCompressedSize(size);
                entry.setSize(size);
                CRC32 crc = new CRC32();
                entry.setCrc(crc.getValue());
                out.putNextEntry(entry);
                while ((len = in.read(buf)) > 0) {
                    crc.update(buf, 0, len);
                    out.write(buf, 0, len);
                }
                entry.setCrc(crc.getValue());
                this.paths.remove(index);
                this.names.remove(index);
            }
            for (int i = 0; i < this.paths.size(); ++i) {
                FileInputStream in = new FileInputStream(this.paths.get(i));
                out.putNextEntry(new ZipEntry(this.names.get(i)));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void collectFiles(File dir, String dirName) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.names.add(dirName + files[i].getName());
                this.paths.add(files[i].getAbsolutePath());
                continue;
            }
            if (files[i].getName().equals(".svn")) continue;
            this.collectFiles(files[i], dirName + files[i].getName() + "/");
        }
    }

    public void listFiles() {
        for (int i = 0; i < this.names.size(); ++i) {
            System.out.println(this.names.get(i));
        }
    }
}

