/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.util.HashMap;

public class OPSChecker
implements ContentChecker,
DocumentValidator {
    OCFPackage ocf;
    Report report;
    String path;
    String mimeType;
    XRefChecker xrefChecker;
    EPUBVersion version;
    private OPSHandler opsHandler = null;
    GenericResourceProvider resourceProvider;
    String properties;
    static XMLValidator xhtmlValidator_20_NVDL = new XMLValidator("schema/20/rng/ops20.nvdl");
    static XMLValidator svgValidator_20_RNG = new XMLValidator("schema/20/rng/svg11.rng");
    static XMLValidator xhtmlValidator_30_RNC = new XMLValidator("schema/30/epub-xhtml-30.rnc");
    static XMLValidator svgValidator_30_RNC = new XMLValidator("schema/30/epub-svg-30.rnc");
    static XMLValidator xhtmlValidator_30_ISOSCH = new XMLValidator("schema/30/epub-xhtml-30-PREP.sch");
    static XMLValidator svgValidator_30_ISOSCH = new XMLValidator("schema/30/epub-svg-30-PREP.sch");
    private HashMap<OPSType, EpubValidator> epubValidatorMap;

    private void initEpubValidatorMap() {
        HashMap<OPSType, EpubValidator> map = new HashMap<OPSType, EpubValidator>();
        map.put(new OPSType("application/xhtml+xml", EPUBVersion.VERSION_2), new EpubValidator(xhtmlValidator_20_NVDL, null));
        map.put(new OPSType("application/xhtml+xml", EPUBVersion.VERSION_3), new EpubValidator(xhtmlValidator_30_RNC, xhtmlValidator_30_ISOSCH));
        map.put(new OPSType("image/svg+xml", EPUBVersion.VERSION_2), new EpubValidator(svgValidator_20_RNG, null));
        map.put(new OPSType("image/svg+xml", EPUBVersion.VERSION_3), new EpubValidator(svgValidator_30_RNC, svgValidator_30_ISOSCH));
        this.epubValidatorMap = map;
    }

    public OPSChecker(OCFPackage ocf, Report report, String path, String mimeType, String properties, XRefChecker xrefChecker, EPUBVersion version) {
        this.initEpubValidatorMap();
        this.ocf = ocf;
        this.resourceProvider = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.mimeType = mimeType;
        this.version = version;
        this.properties = properties;
    }

    public OPSChecker(String path, String mimeType, GenericResourceProvider resourceProvider, Report report, EPUBVersion version) {
        this.initEpubValidatorMap();
        this.resourceProvider = resourceProvider;
        this.mimeType = mimeType;
        this.report = report;
        this.path = path;
        this.version = version;
        this.properties = "singleFileValidation";
    }

    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "OPS/XHTML file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "OPS/XHTML file " + this.path + " cannot be decrypted");
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        XMLValidator rngValidator = null;
        XMLValidator schValidator = null;
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        OPSType type = new OPSType(this.mimeType, this.version);
        EpubValidator epubValidator = this.epubValidatorMap.get(type);
        if (epubValidator != null) {
            rngValidator = epubValidator.xmlValidator;
            schValidator = epubValidator.schValidator;
        }
        try {
            this.validateAgainstSchemas(rngValidator, schValidator);
        }
        catch (IOException e) {
            this.report.error(this.path, 0, 0, e.getMessage());
        }
        return errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    public void validateAgainstSchemas(XMLValidator rngValidator, XMLValidator schValidator) throws IOException {
        XMLParser opsParser = new XMLParser(this.resourceProvider.getInputStream(this.path), this.path, this.mimeType, this.report);
        this.opsHandler = this.version == EPUBVersion.VERSION_2 ? new OPSHandler(this.path, this.xrefChecker, opsParser, this.report) : new OPSHandler30(this.path, this.mimeType, this.properties, this.xrefChecker, opsParser, this.report);
        opsParser.addXMLHandler(this.opsHandler);
        if (rngValidator != null) {
            opsParser.addValidator(rngValidator);
        }
        if (schValidator != null) {
            opsParser.addValidator(schValidator);
        }
        opsParser.process();
    }

    class EpubValidator {
        XMLValidator xmlValidator = null;
        XMLValidator schValidator = null;

        public EpubValidator(XMLValidator xmlValidator, XMLValidator schValidator) {
            this.xmlValidator = xmlValidator;
            this.schValidator = schValidator;
        }
    }
}

