/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.DateParser;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.InvalidDateException;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class OPFHandler
implements XMLHandler {
    OCFPackage ocf;
    Hashtable<String, OPFItem> itemMapById = new Hashtable();
    Hashtable<String, OPFItem> itemMapByPath = new Hashtable();
    Hashtable encryptedItems;
    XMLParser parser;
    Vector<OPFItem> spine = new Vector();
    Vector<OPFItem> items = new Vector();
    Vector<OPFReference> refs = new Vector();
    Report report;
    static HashSet<String> validRoles = new HashSet();
    String path;
    XRefChecker xrefChecker;
    String uniqueIdent;
    boolean uniqueIdentExists = false;
    OPFItem toc;
    boolean opf12PackageFile = false;
    EPUBVersion version;

    OPFHandler(OCFPackage ocf, String path, Report report, XRefChecker xrefChecker, XMLParser parser, EPUBVersion version) {
        this.ocf = ocf;
        this.path = path;
        this.report = report;
        this.xrefChecker = xrefChecker;
        this.parser = parser;
        this.version = version;
    }

    public boolean getOpf12PackageFile() {
        return this.opf12PackageFile;
    }

    public boolean getOpf20PackageFile() {
        return !this.opf12PackageFile;
    }

    public OPFItem getTOC() {
        return this.toc;
    }

    public OPFItem getItemById(String id) {
        return this.itemMapById.get(id);
    }

    public OPFItem getItemByPath(String path) {
        return this.itemMapByPath.get(path);
    }

    public int getSpineItemCount() {
        return this.spine.size();
    }

    public OPFItem getSpineItem(int index) {
        return this.spine.elementAt(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public OPFItem getItem(int index) {
        return this.items.elementAt(index);
    }

    public int getReferenceCount() {
        return this.refs.size();
    }

    public OPFReference getReference(int index) {
        return this.refs.elementAt(index);
    }

    public boolean checkUniqueIdentExists() {
        return this.uniqueIdentExists;
    }

    public void setEncryptedItems(Hashtable encryptedItems) {
        this.encryptedItems = encryptedItems;
    }

    private static boolean isValidRole(String role) {
        return validRoles.contains(role) || role.startsWith("oth.");
    }

    @Override
    public void startElement() {
        boolean registerEntry = true;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (ns == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name = e.getName();
            if (name.equals("package")) {
                String uniqueIdentAttr;
                if (!ns.equals("http://www.idpf.org/2007/opf")) {
                    this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "OPF file is using OEBPS 1.2 syntax allowing backwards compatibility");
                    this.opf12PackageFile = true;
                }
                if ((uniqueIdentAttr = e.getAttribute("unique-identifier")) != null && !uniqueIdentAttr.equals("")) {
                    this.uniqueIdent = uniqueIdentAttr;
                } else {
                    this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "unique-identifier attribute in package element must be present and have a value");
                }
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                String href = e.getAttribute("href");
                if (!(href == null || this.version == EPUBVersion.VERSION_3 && href.startsWith("http://"))) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                    }
                    catch (IllegalArgumentException ex) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ex.getMessage());
                        href = null;
                    }
                }
                String mimeType = e.getAttribute("media-type");
                String fallback = e.getAttribute("fallback");
                String fallbackStyle = e.getAttribute("fallback-style");
                String namespace = e.getAttribute("island-type");
                String properties = e.getAttribute("properties");
                if (this.version == EPUBVersion.VERSION_3 && href.startsWith("http://") && !OPFChecker30.isBlessedAudioType(mimeType)) {
                    if (OPFChecker30.isCoreMediaType(mimeType)) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Only audio and video foreign resources are permitted!");
                    } else {
                        this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Only audio and video foreign resources are permitted! The checker can't validate foreign resources!");
                    }
                }
                OPFItem item = new OPFItem(id, href, mimeType, fallback, fallbackStyle, namespace, properties, this.parser.getLineNumber(), this.parser.getColumnNumber());
                if (id != null) {
                    this.itemMapById.put(id, item);
                }
                if (properties != null) {
                    String[] propertyArray = properties.split(" ");
                    for (int i = 0; i < propertyArray.length; ++i) {
                        if (!propertyArray[i].equals("nav")) continue;
                        item.setNav(true);
                        break;
                    }
                }
                if (href != null && registerEntry) {
                    this.itemMapByPath.put(href, item);
                    this.items.add(item);
                }
            } else if (name.equals("reference")) {
                String type = e.getAttribute("type");
                String title = e.getAttribute("title");
                String href = e.getAttribute("href");
                if (href != null && this.xrefChecker != null) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                        this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 1);
                    }
                    catch (IllegalArgumentException ex) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ex.getMessage());
                        href = null;
                    }
                }
                OPFReference ref = new OPFReference(type, title, href, this.parser.getLineNumber(), this.parser.getColumnNumber());
                this.refs.add(ref);
            } else if (name.equals("spine")) {
                String idref = e.getAttribute("toc");
                if (idref != null) {
                    this.toc = this.itemMapById.get(idref);
                    if (this.toc == null) {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "item with id '" + idref + "' not found");
                    } else {
                        this.toc.setNcx(true);
                        if (this.toc.getMimeType() != null && !this.toc.getMimeType().equals("application/x-dtbncx+xml")) {
                            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "toc attribute references resource with non-NCX mime type; \"application/x-dtbncx+xml\" is expected");
                        }
                    }
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                if (idref != null) {
                    OPFItem item = this.getItemById(idref);
                    if (item != null) {
                        this.spine.add(item);
                        item.setInSpine(true);
                    } else {
                        this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "item with id '" + idref + "' not found");
                    }
                }
            } else if ((name.equals("dc-metadata") || name.equals("x-metadata")) && !this.opf12PackageFile) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "use of deprecated element '" + name + "'");
            }
        } else if (ns.equals("http://purl.org/dc/elements/1.1/")) {
            String role;
            String name = e.getName();
            if (name.equals("identifier")) {
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent)) {
                    this.uniqueIdentExists = true;
                }
            } else if (name.equals("creator") && (role = e.getAttributeNS("http://www.idpf.org/2007/opf", "role")) != null && !role.equals("") && !OPFHandler.isValidRole(role)) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "role value '" + role + "' is not valid");
            }
        }
    }

    public boolean isNotRequiredContent(String href) {
        if (href.endsWith(".opf")) {
            return false;
        }
        if (href.endsWith(".html")) {
            return false;
        }
        if (href.endsWith(".ncx")) {
            return false;
        }
        if (href.endsWith(".xpgt")) {
            return false;
        }
        return !href.endsWith(".xhtml");
    }

    @Override
    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/")) {
            String name = e.getName();
            if (name.equals("identifier")) {
                String idval;
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent) && (idval = (String)e.getPrivateData()) != null && this.ocf != null) {
                    this.ocf.setUniqueIdentifier(idval);
                }
            } else if (name.equals("date")) {
                String dateval = (String)e.getPrivateData();
                DateParser dateParser = new DateParser();
                boolean iso8601 = false;
                if (dateval != null) {
                    try {
                        dateParser.parse(dateval);
                        iso8601 = true;
                    }
                    catch (InvalidDateException d) {
                        iso8601 = false;
                    }
                }
                if (!iso8601) {
                    this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "date value '" + (dateval == null ? "" : dateval) + "' is not valid. The date must be in the form YYYY, YYYY-MM or YYYY-MM-DD (e.g., \"1993\", \"1993-05\", or \"1993-05-01\"). See http://www.w3.org/TR/NOTE-datetime.");
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        String name;
        XMLElement e = this.parser.getCurrentElement();
        if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/") && ((name = e.getName()).equals("identifier") || name.equals("date"))) {
            String val = (String)e.getPrivateData();
            String text = new String(chars, start, len);
            val = val == null ? text : val + text;
            e.setPrivateData(val);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    static {
        String[] list = new String[]{"acp", "act", "adp", "aft", "anl", "anm", "ann", "ant", "app", "aqt", "arc", "ard", "arr", "art", "asg", "asn", "att", "auc", "aud", "aui", "aus", "aut", "bdd", "bjd", "bkd", "bkp", "bnd", "bpd", "bsl", "ccp", "chr", "clb", "cli", "cll", "clt", "cmm", "cmp", "cmt", "cng", "cnd", "cns", "coe", "col", "com", "cos", "cot", "cov", "cpc", "cpe", "cph", "cpl", "cpt", "cre", "crp", "crr", "csl", "csp", "cst", "ctb", "cte", "ctg", "ctr", "cts", "ctt", "cur", "cwt", "dfd", "dfe", "dft", "dgg", "dis", "dln", "dnc", "dnr", "dpc", "dpt", "drm", "drt", "dsr", "dst", "dtc", "dte", "dtm", "dto", "dub", "edt", "egr", "elg", "elt", "eng", "etr", "exp", "fac", "fld", "flm", "fmo", "fpy", "fnd", "frg", "gis", "grt", "hnr", "hst", "ill", "ilu", "ins", "inv", "itr", "ive", "ivr", "lbr", "lbt", "ldr", "led", "lee", "lel", "len", "let", "lgd", "lie", "lil", "lit", "lsa", "lse", "lso", "ltg", "lyr", "mcp", "mfr", "mdc", "mod", "mon", "mrk", "msd", "mte", "mus", "nrt", "opn", "org", "orm", "oth", "own", "pat", "pbd", "pbl", "pdr", "pfr", "pht", "plt", "pma", "pmn", "pop", "ppm", "ppt", "prc", "prd", "prf", "prg", "prm", "pro", "prt", "pta", "pte", "ptf", "pth", "ptt", "rbr", "rce", "rcp", "red", "ren", "res", "rev", "rps", "rpt", "rpy", "rse", "rsg", "rsp", "rst", "rth", "rtm", "sad", "sce", "scl", "scr", "sds", "sec", "sgn", "sht", "sng", "spk", "spn", "spy", "srv", "std", "stl", "stm", "stn", "str", "tcd", "tch", "ths", "trc", "trl", "tyd", "tyg", "vdg", "voc", "wam", "wdc", "wde", "wit"};
        for (int i = 0; i < list.length; ++i) {
            validRoles.add(list[i]);
        }
    }
}

