/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionHandler;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;

public class OCFChecker {
    OCFPackage ocf;
    Report report;
    Hashtable encryptedItems;
    private EPUBVersion version = EPUBVersion.VERSION_3;
    static final String containerEntry = "META-INF/container.xml";
    static final String encryptionEntry = "META-INF/encryption.xml";
    static final String signatureEntry = "META-INF/signatures.xml";
    static XMLValidator containerValidator = new XMLValidator("schema/20/rng/container.rng");
    static XMLValidator encryptionValidator = new XMLValidator("schema/20/rng/encryption.rng");
    static XMLValidator signatureValidator = new XMLValidator("schema/20/rng/signatures.rng");
    static XMLValidator containerValidator30 = new XMLValidator("schema/30/ocf-container-30.rnc");
    static XMLValidator encryptionValidator30 = new XMLValidator("schema/30/ocf-encryption-30.rnc");
    static XMLValidator signatureValidator30 = new XMLValidator("schema/30/ocf-signatures-30.rnc");
    private static HashMap<OPSType, XMLValidator> xmlValidatorMap;
    XMLParser parser = null;

    public OCFChecker(OCFPackage ocf, Report report) {
        this.ocf = ocf;
        this.report = report;
    }

    public void runChecks() {
        if (!this.ocf.hasEntry(containerEntry)) {
            this.report.error(null, 0, 0, "Required META-INF/container.xml resource is missing");
            return;
        }
        XMLParser containerParser = null;
        try {
            containerParser = new XMLParser(this.ocf.getInputStream(containerEntry), containerEntry, "xml", this.report);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OCFHandler containerHandler = new OCFHandler(containerParser);
        containerParser.addXMLHandler(containerHandler);
        containerParser.process();
        String rootPath = containerHandler.getRootPath();
        if (rootPath != null && this.ocf.hasEntry(rootPath)) {
            try {
                this.version = ResourceUtil.retrieveOpfVersion(this.ocf.getInputStream(rootPath));
                if (this.ocf.hasEntry("mimetype") && !CheckUtil.checkTrailingSpaces(this.ocf.getInputStream("mimetype"), this.version)) {
                    this.report.error("mimetype", 0, 0, "Mimetype file should contain only the string \"application/epub+zip\".");
                }
                this.validate();
            }
            catch (InvalidVersionException e) {
                this.report.error(rootPath, -1, -1, e.getMessage());
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (rootPath != null) {
            OPFChecker opfChecker = null;
            opfChecker = this.version == EPUBVersion.VERSION_2 ? new OPFChecker(this.ocf, this.report, rootPath, containerHandler.getContainerEntries(), this.version) : new OPFChecker30(this.ocf, this.report, rootPath, containerHandler.getContainerEntries(), this.version);
            opfChecker.runChecks();
        }
    }

    public void parse(String path, XMLHandler handler, Report report, XMLValidator validator) throws IOException {
        this.parser = new XMLParser(this.ocf.getInputStream(path), containerEntry, "xml", report);
        this.parser.addXMLHandler(handler);
        this.parser.addValidator(validator);
        this.parser.process();
    }

    public boolean validate() {
        try {
            XMLHandler handler = new OCFHandler(this.parser);
            this.parse(containerEntry, handler, this.report, xmlValidatorMap.get(new OPSType(containerEntry, this.version)));
            if (this.ocf.hasEntry(encryptionEntry)) {
                handler = new EncryptionHandler(this.ocf, this.parser);
                this.parse(encryptionEntry, handler, this.report, xmlValidatorMap.get(new OPSType(encryptionEntry, this.version)));
            }
            if (this.ocf.hasEntry(signatureEntry)) {
                handler = new OCFHandler(this.parser);
                this.parse(signatureEntry, handler, this.report, xmlValidatorMap.get(new OPSType(signatureEntry, this.version)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        System.out.println("RootPath is not an OPF file");
        return null;
    }

    static {
        HashMap<OPSType, XMLValidator> map = new HashMap<OPSType, XMLValidator>();
        map.put(new OPSType(containerEntry, EPUBVersion.VERSION_2), containerValidator);
        map.put(new OPSType(containerEntry, EPUBVersion.VERSION_3), containerValidator30);
        map.put(new OPSType(encryptionEntry, EPUBVersion.VERSION_2), encryptionValidator);
        map.put(new OPSType(encryptionEntry, EPUBVersion.VERSION_3), encryptionValidator30);
        map.put(new OPSType(signatureEntry, EPUBVersion.VERSION_2), signatureValidator);
        map.put(new OPSType(signatureEntry, EPUBVersion.VERSION_3), signatureValidator30);
        xmlValidatorMap = map;
    }
}

