/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;

public class DTBookHandler
implements XMLHandler {
    XMLParser parser;
    String path;
    XRefChecker xrefChecker;

    DTBookHandler(XMLParser parser, String path, XRefChecker xrefChecker) {
        this.parser = parser;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        String id = e.getAttribute("id");
        if (ns.equals("http://www.daisy.org/z3986/2005/dtbook/")) {
            String uri = null;
            if (name.equals("a")) {
                uri = e.getAttribute("href");
                String external = e.getAttribute("external");
                if (uri != null && external.equals("true")) {
                    if (OPSHandler.isRegisteredSchemaType(uri)) {
                        uri = null;
                    } else if (uri.indexOf(58) > 0) {
                        this.parser.getReport().warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "use of non-registered URI schema type in href: " + uri);
                        uri = null;
                    }
                }
            } else if (name.equals("link")) {
                uri = e.getAttribute("href");
            } else if (name.equals("img")) {
                uri = e.getAttribute("src");
            }
            if (uri != null) {
                uri = PathUtil.resolveRelativeReference(this.path, uri);
                this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), uri, name.equals("img") ? 2 : 1);
            }
            if (id != null) {
                this.xrefChecker.registerAnchor(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), id, 1);
            }
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

