package jp.cssj.sakae.gc.font.util;

import jp.cssj.cr.compat.XMatrix;
import jp.cssj.cr.compat.XPath;
import jp.cssj.sakae.font.BBox;
import jp.cssj.sakae.font.FontSource;
import jp.cssj.sakae.font.ShapedFont;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.font.FontMetrics;
import jp.cssj.sakae.gc.font.FontStyle;
import jp.cssj.sakae.gc.text.Text;
import android.graphics.Path;

/**
 * テキスト描画・フォント関連のユーティリティです。
 * 
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: FontUtils.java,v 1.4 2007-05-06 04:27:03 miyabe Exp $
 */
public final class FontUtils {
	private FontUtils() {
		// unused
	}

	/**
	 * フォント名を大文字に統一し、ハイフン、スペースを除去します。
	 * 
	 * @param fontName
	 * @return
	 */
	public static String normalizeName(String fontName) {
		StringBuffer buff = new StringBuffer();
		for (int i = 0; i < fontName.length(); ++i) {
			char ch = fontName.charAt(i);
			if (Character.isWhitespace(ch) || ch == '-' || ch == '_') {
				continue;
			}
			buff.append(Character.toUpperCase(ch));
		}
		return buff.toString();
	}

	public static boolean equals(FontStyle a, FontStyle b) {
		return a.getFamily().equals(b.getFamily())
				&& a.getSize() == b.getSize() && a.getStyle() == b.getStyle()
				&& a.getWeight() == b.getWeight()
				&& a.getDirection() == b.getDirection()
				&& a.getPolicy().equals(b.getPolicy());
	}

	public static int hashCode(FontStyle fontStyle) {
		int h = fontStyle.getFamily().hashCode();
		long a = Double.doubleToLongBits(fontStyle.getSize());
		h = 31 * h + (int) (a ^ (a >>> 32));
		h = 31 * h + fontStyle.getStyle();
		h = 31 * h + fontStyle.getWeight();
		h = 31 * h + fontStyle.getDirection();
		h = 31 * h + fontStyle.getPolicy().hashCode();
		return h;
	}

	/**
	 * フォントを描画します。
	 * 
	 * @param gc
	 * @param font
	 * @param text
	 */
	// public static void drawPDFFont(GC gc, ShapedFont font, Text text)
	// throws GraphicsException {
	// FontStyle fontStyle = text.getFontStyle();
	// byte direction = fontStyle.getDirection();
	// double fontSize = fontStyle.getSize();
	// int goff = text.getGOff();
	// int glen = text.getGLen();
	// int[] gids = text.getGIDs();
	// double letterSpacing = text.getLetterSpacing();
	// double[] xadvances = text.getXAdvances(false);
	// FontMetrics fm = text.getFontMetrics();
	// XMatrix at;
	// {
	// double s = fontSize / FontSource.UNITS_PER_EM;
	// at = XMatrix.getScaleInstance(s, s);
	// }
	//
	// if (direction == FontStyle.DIRECTION_TB) {
	// // 縦書きモード
	// if (font.getFontSource().getDirection() == direction) {
	// // 縦書き対応フォント
	// gc.transform(XMatrix.getTranslateInstance(-fontSize / 2.0,
	// fontSize * 0.88));
	// for (int i = 0; i < glen; ++i) {
	// int gid = gids[goff + i];
	// Path shape = font.getShapeByGID(gid);
	// if (shape != null) {
	// XPath path = new XPath();
	// path.addPath(shape, at);
	// double width = (fontSize - fm.getWidth(gid)) / 2.0;
	// if (width != 0) {
	// gc.begin();
	// gc
	// .transform(XMatrix.getTranslateInstance(
	// width, 0));
	// }
	// gc.fill(path);
	// if (width != 0) {
	// gc.end();
	// }
	// }
	// double dy = fm.getAdvance(gid) + letterSpacing;
	// if (xadvances != null) {
	// dy += xadvances[i];
	// }
	// gc.transform(XMatrix.getTranslateInstance(0, dy));
	// }
	// return;
	// } else {
	// // 横倒し
	// gc.transform(XMatrix.getRotateInstance(Math.PI / 2.0));
	// BBox bbox = font.getFontSource().getBBox();
	// double dy = ((bbox.lly + bbox.ury) * fontSize / FontSource.UNITS_PER_EM)
	// / 2.0;
	// gc.transform(XMatrix.getTranslateInstance(0, dy));
	// }
	// }
	// // 横書き
	// int pgid = 0;
	// for (int i = 0; i < glen; ++i) {
	// int gid = gids[goff + i];
	// Path shape = font.getShapeByGID(gid);
	// if (shape != null) {
	// XPath path = new XPath();
	// path.addPath(shape, at);
	// gc.fill(path);
	// }
	// double dx = fm.getAdvance(gid) + letterSpacing;
	// if (i > 0) {
	// dx -= fm.getKerning(pgid, gid);
	// }
	// if (xadvances != null) {
	// dx += xadvances[i];
	// }
	// gc.transform(XMatrix.getTranslateInstance(dx, 0));
	// pgid = gid;
	// }
	// }

	public static void drawPDFFont(GC gc, ShapedFont font, Text text)
			throws GraphicsException {
		FontStyle fontStyle = text.getFontStyle();
		byte direction = fontStyle.getDirection();
		float fontSize = (float) fontStyle.getSize();
		int goff = text.getGOff();
		int glen = text.getGLen();
		int[] gids = text.getGIDs();
		float letterSpacing = (float) text.getLetterSpacing();
		double[] xadvances = text.getXAdvances(false);
		FontMetrics fm = text.getFontMetrics();
		XMatrix at;
		{
			double s = fontSize / FontSource.UNITS_PER_EM;
			at = XMatrix.getScaleInstance(s, s);
		}

		if (direction == FontStyle.DIRECTION_TB) {
			// 縦書きモード
			if (font.getFontSource().getDirection() == direction) {
				// 縦書き対応フォント
				gc.transform(XMatrix.getTranslateInstance(-fontSize / 2.0,
						fontSize * 0.88));
				XPath path = new XPath();
				int gid = -1;
				for (int i = 0; i < glen; ++i) {
					XMatrix at2 = at;
					if (i > 0) {
						float dy = (float) fm.getAdvance(gid) + letterSpacing;
						if (xadvances != null) {
							dy += xadvances[i];
						}
						at.postTranslate(0, dy);
					}
					gid = gids[goff + i];
					Path shape = font.getShapeByGID(gid);
					if (shape != null) {
						float width = (fontSize - (float) fm.getWidth(gid)) / 2.0f;
						if (width != 0) {
							at2 = new XMatrix(at);
							at2.postTranslate(width, 0);
						}
						path.addPath(shape, at2);
					}
				}
				gc.fill(path);
				return;
			} else {
				// 横倒し
				gc.transform(XMatrix.getRotateInstance(Math.PI / 2.0));
				BBox bbox = font.getFontSource().getBBox();
				double dy = ((bbox.lly + bbox.ury) * fontSize / FontSource.UNITS_PER_EM) / 2.0;
				gc.transform(XMatrix.getTranslateInstance(0, dy));
			}
		}
		// 横書き
		int pgid = 0;
		XPath path = new XPath();
		for (int i = 0; i < glen; ++i) {
			int gid = gids[goff + i];
			if (i > 0) {
				float dx = (float) fm.getAdvance(pgid) + letterSpacing;
				if (i > 0) {
					dx -= fm.getKerning(pgid, gid);
				}
				if (xadvances != null) {
					dx += xadvances[i];
				}
				at.postTranslate(dx, 0);
			}
			Path shape = font.getShapeByGID(gid);
			if (shape != null) {
				path.addPath(shape, at);
			}
			pgid = gid;
		}
		gc.fill(path);
	}
}