package jp.cssj.homare.impl.css.part;

import jp.cssj.cr.compat.XPath;
import jp.cssj.cr.compat.XRectF;
import jp.cssj.homare.css.util.ColorValueUtils;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.image.Image;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: CircleImage.java,v 1.2 2007-05-06 04:24:06 miyabe Exp $
 */
public class CheckBoxImage implements Image {
	private final boolean checked, disabled;

	public CheckBoxImage(boolean checked, boolean disabled) {
		this.checked = checked;
		this.disabled = disabled;
	}

	public double getWidth() {
		return 12.0;
	}

	public double getHeight() {
		return 12.0;
	}

	public String getAltString() {
		return "○";
	}

	public void drawTo(GC gc) throws GraphicsException {
		gc.begin();

		XRectF frame = new XRectF(2, 2, 8, 8);
		XPath path = new XPath();
		path.moveTo(3, 5);
		path.lineTo(6, 8);
		path.lineTo(12, 2);
		XPath check = path;

		gc.setFillPaint(this.disabled ? ColorValueUtils.LIGHTGRAY
				: ColorValueUtils.WHITE);
		gc.setStrokePaint(this.disabled ? ColorValueUtils.DIMGRAY
				: ColorValueUtils.BLACK);
		gc.setLineWidth(1.0);
		gc.setLinePattern(GC.STROKE_SOLID);
		gc.fillDraw(frame);

		if (this.checked) {
			gc.setLineWidth(2.0);
			gc.setLinePattern(GC.STROKE_SOLID);
			gc.draw(check);
		}

		gc.end();
	}
}
