package jp.cssj.cr.gc;

import java.util.ArrayList;
import java.util.List;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

public class Annotations {
	private List<AndroidImage> images = new ArrayList<AndroidImage>();
	private List<RectF> imageBounds = new ArrayList<RectF>();
	private int selectedImage = -1;

	public void clear() {
		this.images.clear();
		this.imageBounds.clear();
		this.selectedImage = -1;
	}

	public void addImage(AndroidImage image, RectF r) {
		this.images.add(image);
		this.imageBounds.add(r);
	}

	public AndroidImage selectImage(float x, float y) {
		for (int i = 0; i < this.imageBounds.size(); ++i) {
			RectF r = this.imageBounds.get(i);
			if (r.contains(x, y)) {
				this.selectedImage = i;
				return this.images.get(this.selectedImage);
			}
		}
		this.clearSelectedImage();
		return null;
	}

	public AndroidImage getSelectedImage() {
		if (this.selectedImage == -1) {
			return null;
		}
		return this.images.get(this.selectedImage);
	}

	public RectF getSelectedRect() {
		if (this.selectedImage == -1) {
			return null;
		}
		return this.imageBounds.get(this.selectedImage);
	}

	public int getSelectedIndex() {
		return this.selectedImage;
	}

	public void drawImage(Canvas canvas, int index) {
		RectF r = this.imageBounds.get(index);
		AndroidImage image = this.images.get(index);
		Drawable d = image.getDrawable();
		d.setBounds(new Rect((int) r.left, (int) r.top, (int) r.right,
				(int) r.bottom));
		d.draw(canvas);
		if (index == this.selectedImage) {
			Paint paint = new Paint();
			paint.setStyle(Style.STROKE);
			paint.setARGB(0xFF, 0, 0, 0xFF);
			paint.setStrokeWidth(3f);
			canvas.drawRect(r, paint);
		}
	}

	public void drawSelectedImageFrame(Canvas canvas) {
		if (this.selectedImage == -1) {
			return;
		}
		RectF r = this.imageBounds.get(this.selectedImage);
		Paint paint = new Paint();
		paint.setStyle(Style.STROKE);
		paint.setARGB(0xFF, 0, 0, 0xFF);
		paint.setStrokeWidth(3f);
		canvas.drawRect(r, paint);
	}

	public void clearSelectedImage() {
		this.selectedImage = -1;
	}
}
