package jp.cssj.cr.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DatabaseHelper extends SQLiteOpenHelper {
	public DatabaseHelper(Context context) {
		super(context, "copper.db", null, 6);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE books (" + "file TEXT PRIMARY KEY,"
				+ "last_accessed LONG NOT NULL," + "item INTEGER, "
				+ "page INTEGER)");
		this.createSetting(db);
	}

	private void createSetting(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE setting (" + "file TEXT PRIMARY KEY," + "direction INTEGER NOT NULL,"
				+ "reverse INTEGER NOT NULL," + "columns INTEGER NOT NULL,"
				+ "font_size INTEGER NOT NULL, margin INTEGER NOT NULL)");
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		if (oldVersion <= 1 && newVersion >= 2) {
			db.execSQL("ALTER TABLE books ADD COLUMN item INTEGER");
			this.createSetting(db);
		}
		if (oldVersion <= 2 && newVersion >= 3) {
			db.execSQL("UPDATE setting SET font_size=75 WHERE font_size=2");
			db.execSQL("UPDATE setting SET font_size=100 WHERE font_size=3");
			db.execSQL("UPDATE setting SET font_size=150 WHERE font_size=4");
		}
		if (oldVersion <= 3 && newVersion >= 4) {
			db.execSQL("ALTER TABLE setting ADD COLUMN margin INTEGER NOT NULL DEFAULT 0");
		}
		if (oldVersion <= 4 && newVersion >= 5) {
			db.execSQL("CREATE TABLE x_setting ("
					+ "vertical INTEGER NOT NULL,"
					+ "reverse INTEGER NOT NULL," + "columns INTEGER NOT NULL,"
					+ "font_size INTEGER NOT NULL, margin INTEGER NOT NULL)");
			db.execSQL("INSERT INTO x_setting(vertical,reverse,columns,font_size,margin) SELECT vertical,0,columns,font_size,margin FROM setting");
			db.execSQL("DROP TABLE setting");
			db.execSQL("ALTER TABLE x_setting RENAME TO setting");
		}
		if (oldVersion <= 5 && newVersion >= 6) {
			db.execSQL("ALTER TABLE books ADD COLUMN page INTEGER");
			db.execSQL("DROP TABLE setting");
			this.createSetting(db);
		}
	}
}
