package jp.cssj.cr.epub;

import android.util.Log;

import com.google.ads.Ad;
import com.google.ads.AdListener;
import com.google.ads.AdRequest;
import com.google.ads.AdRequest.ErrorCode;
import com.google.ads.AdView;

public class DefaultAdListener implements AdListener {
	private AdRequest request;

	public DefaultAdListener(AdRequest request) {
		this.request = request;
	}

	public void onDismissScreen(Ad a) {
		Log.d("Ad", "dismiss");
	}

	public void onFailedToReceiveAd(Ad a, ErrorCode ec) {
		Log.d("Ad", a + "/" + ec);
		((AdView) a).loadAd(this.request);
	}

	public void onLeaveApplication(Ad a) {
		Log.d("Ad", "leave");
	}

	public void onPresentScreen(Ad a) {
		Log.d("Ad", "present");
	}

	public void onReceiveAd(Ad a) {
		Log.d("Ad", "receive");
	}
}
