package jp.cssj.print.epub.util;

import java.lang.Character.UnicodeBlock;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.print.epub.Contents.Item;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XHTMLHandler extends XMLFilterImpl {
	static final String XHTML_NS = "http://www.w3.org/1999/xhtml/";
	static final AttributesImpl TCY = new AttributesImpl();
	static {
		TCY.addAttribute("", "class", "class", "CDATA", "x-epub-tcy pre");
	}
	boolean pre;
	final boolean vertical;
	List<Attributes> attStack = new ArrayList<Attributes>();
	final AttributesImpl attsi = new AttributesImpl();
	final Item item;

	public XHTMLHandler(ContentHandler thandler, Item item, boolean vertical) {
		super.setContentHandler(thandler);
		this.item = item;
		this.vertical = vertical;
	}

	public XHTMLHandler(XMLReader reader, Item item, boolean vertical) {
		super(reader);
		this.item = item;
		this.vertical = vertical;
	}

	public void characters(char[] ch, int off, int len) throws SAXException {
		if (this.vertical && !this.pre) {
			toSimpleKansuji(ch, off, len);
			int end = off + len;
			int run = 0;
			for (int i = off; i < end; ++i) {
				char c = ch[i];
				if (c >= '0' && c <= '9') {
					++run;
					continue;
				}
				if (run == 2) {
					UnicodeBlock b = UnicodeBlock.of(c);
					if (!(b == UnicodeBlock.CJK_COMPATIBILITY
							|| b == UnicodeBlock.CJK_COMPATIBILITY_FORMS
							|| b == UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
							|| b == UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT
							|| b == UnicodeBlock.CJK_RADICALS_SUPPLEMENT
							|| b == UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
							|| b == UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
							|| b == UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
							|| b == UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
							|| b == UnicodeBlock.HIRAGANA
							|| b == UnicodeBlock.KATAKANA
							|| b == UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || b == UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS)) {
						continue;
					}
					int tlen = i - off - run;
					if (tlen > 0) {
						toFullWidthNumber(ch, off, tlen);
						super.characters(ch, off, tlen);
					}
					super.startElement(XHTML_NS, "span", "span", TCY);
					super.characters(ch, i - run, run);
					super.endElement(XHTML_NS, "span", "span");
					len -= i - off;
					off = i;
				}
				run = 0;
			}
			if (len == 0) {
				return;
			}
			toFullWidthNumber(ch, off, len);
		}
		super.characters(ch, off, len);
	}

	private static boolean pre(String lName, Attributes atts) {
		String clazz = atts.getValue("class");
		if (lName.equals("style") || lName.equals("script")) {
			return true;
		}
		if (clazz == null) {
			return false;
		}
		if (clazz.indexOf("tcy") != -1 || clazz.indexOf("pre") != -1) {
			return true;
		}
		return false;
	}

	public void startElement(String uri, String lName, String qName,
			Attributes atts) throws SAXException {
		boolean inBody = lName.equals("body");
		if (inBody) {
			String type;
			if (this.item.guide != null && this.item.guide.type != null) {
				type = this.item.guide.type;
			} else {
				type = "text";
			}
			this.attsi.setAttributes(atts);
			atts = this.attsi;
			int classIndex = this.attsi.getIndex("", "class");
			StringBuffer classBuff;
			if (classIndex != -1) {
				classBuff = new StringBuffer(this.attsi.getValue(classIndex));
				this.attsi.removeAttribute(classIndex);
				classBuff.append(' ');
			} else {
				classBuff = new StringBuffer();
			}
			classBuff.append("x-epub-").append(type);
			this.attsi.addAttribute("", "class", "class", "CDATA",
					classBuff.toString());
		}
		this.attStack.add(new AttributesImpl(atts));
		if (pre(lName, atts)) {
			pre = true;
		}
		super.startElement(uri, lName, qName, atts);
		if (inBody) {
			this.attsi.clear();
			this.attsi.addAttribute("", "id", "id", "CDATA",
					"x-epub-left-nombre");
			super.startElement(XHTML_NS, "div", "div", this.attsi);
			super.endElement(XHTML_NS, "div", "div");
			this.attsi.clear();
			this.attsi.addAttribute("", "id", "id", "CDATA",
					"x-epub-right-nombre");
			super.startElement(XHTML_NS, "div", "div", this.attsi);
			super.endElement(XHTML_NS, "div", "div");
		}
	}

	public void endElement(String uri, String lName, String qName)
			throws SAXException {
		Attributes atts = this.attStack.remove(this.attStack.size() - 1);
		if (pre(lName, atts)) {
			pre = false;
		}
		super.endElement(uri, lName, qName);
	}

	private static final String from = "０１２３４５６７８９“”．－";

	private static final String to = "〇一二三四五六七八九〝〟・―";

	public static void toSimpleKansuji(char[] ch, int off, int len) {
		int end = off + len;
		for (int i = off; i < end; ++i) {
			if (ch[i] == 'h' && (end - i >= 5) && ch[i + 1] == 't'
					&& ch[i + 2] == 't' && ch[i + 3] == 'p' && ch[i + 4] == ':') {
				for (i += 5; i < end; ++i) {
					if (Character.isWhitespace(ch[i]) || ch[i] > 255) {
						break;
					}
				}
				if (i >= end) {
					break;
				}
			}
			ch[i] = toSimpleKansuji(ch[i]);
		}
	}

	public static char toSimpleKansuji(char c) {
		int ix = from.indexOf(c);
		if (ix != -1) {
			c = to.charAt(ix);
		}
		return c;
	}

	private static final String from2 = "0123456789.,";

	private static final String to2 = "０１２３４５６７８９・，";

	public static void toFullWidthNumber(char[] ch, int off, int len) {
		int end = off + len;
		for (int i = off; i < end; ++i) {
			if (ch[i] == 'h' && (end - i >= 5) && ch[i + 1] == 't'
					&& ch[i + 2] == 't' && ch[i + 3] == 'p' && ch[i + 4] == ':') {
				for (i += 5; i < end; ++i) {
					if (Character.isWhitespace(ch[i]) || ch[i] > 255) {
						break;
					}
				}
				if (i >= end) {
					break;
				}
			}
			ch[i] = toFullWidthNumber(ch[i]);
		}
	}

	public static char toFullWidthNumber(char c) {
		int ix = from2.indexOf(c);
		if (ix != -1) {
			c = to2.charAt(ix);
		}
		return c;
	}
}
