package jp.cssj.print.epub;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipArchiveFile implements ArchiveFile {
	private final ZipFile zip;

	public ZipArchiveFile(ZipFile zip) {
		this.zip = zip;
	}

	public boolean exists(String path) {
		return this.zip.getEntry(path) != null;
	}

	public InputStream getInputStream(String path)
			throws FileNotFoundException, IOException {
		ZipEntry entry = this.zip.getEntry(path);
		if (entry == null) {
			throw new FileNotFoundException(path);
		}
		return this.zip.getInputStream(entry);
	}
}
