package jp.cssj.print.epub;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XHTMLTitleHandler extends DefaultHandler {
	private StringBuffer textBuff = null;

	public void startElement(String uri, String lName, String qName,
			Attributes atts) throws SAXException {
		if (lName.equals("title")) {
			this.textBuff = new StringBuffer();
		} else if (lName.equals("body")) {
			throw new SAXException();
		}
	}

	public void characters(char[] ch, int off, int len) throws SAXException {
		if (this.textBuff != null) {
			this.textBuff.append(ch, off, len);
		}
	}

	public void endElement(String uri, String lName, String qName)
			throws SAXException {
		if (lName.equals("title")) {
			throw new SAXException();
		}
	}

	public String getTitle() {
		if (this.textBuff == null) {
			return null;
		}
		return this.textBuff.toString();
	}
}
