package jp.cssj.print.epub;

import jp.cssj.print.epub.Contents.Item;

/**
 * 目次(NCX)に相当する情報です。
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 */
public class Toc {
	/**
	 * 目次の項目です。
	 */
	public static class NavPoint {
		/** 項目のIDです。 */
		public String id;
		/** 項目のラベルです。 */
		public String label;
		/** NCXからの相対パスです。 */
		public String src;
		/** ZIPファイル内でのパスです。 */
		public String fullPath;
		/** 対応するアイテムです。 */
		public Item item;
		/** 項目の再生順序です。 */
		public int playOrder;
	}

	/**
	 * 目次のタイトルです。
	 */
	public String docTitle;

	/**
	 * 全ての項目のリストです。
	 */
	public NavPoint[] navPoints;
}
