package jp.cssj.print.epub;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.cssj.print.epub.Contents.Item;
import jp.cssj.print.epub.Contents.Reference;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

//OPFの読み込み
class OPFHandler extends DefaultHandler {
	final URI base;
	Contents contents = new Contents();
	StringBuffer textBuff = null;
	List<Item> items = new ArrayList<Item>();
	Map<String, Item> idToItem = new HashMap<String, Item>();
	Map<String, Item> hrefToItem = new HashMap<String, Item>();
	List<Item> spine = new ArrayList<Item>();
	List<Reference> guide = new ArrayList<Reference>();

	public OPFHandler(String base) {
		this.base = URI.create(base);
		this.contents.base = base;
	}

	public void startElement(String uri, String lName, String qName,
			Attributes atts) throws SAXException {
		if (uri.equals("http://purl.org/dc/elements/1.1/")) {
			this.textBuff = new StringBuffer();
		} else if (uri.equals("http://www.idpf.org/2007/opf")) {
			// 書籍に含まれるファイル情報を取得
			if (lName.equals("item")) {
				Item item = new Item();
				item.id = atts.getValue("id");
				item.href = atts.getValue("href");
				item.fullPath = this.base.resolve(item.href).getPath();
				item.mediaType = atts.getValue("media-type");
				this.items.add(item);
				this.idToItem.put(item.id, item);
				this.hrefToItem.put(item.href, item);
			} else if (lName.equals("spine")) {
				String toc = atts.getValue("toc");
				this.contents.toc = (Item) this.idToItem.get(toc);
				String pageProgressionDirection = atts
						.getValue("page-progression-direction");
				if (pageProgressionDirection != null) {
					if (pageProgressionDirection.equals("ltr")) {
						this.contents.pageProgressionDirection = Contents.PAGE_PROGRESSION_DIRECTION_LTR;
					} else if (pageProgressionDirection.equals("ltr")) {
						this.contents.pageProgressionDirection = Contents.PAGE_PROGRESSION_DIRECTION_RTL;
					}
				}
			} else if (lName.equals("itemref")) {
				String idref = atts.getValue("idref");
				Item item = (Item) this.idToItem.get(idref);
				if (item != null) {
					item.index = this.spine.size();
					this.spine.add(item);
				}
				String properties = atts.getValue("properties");
				if (properties != null) {
					if (properties.indexOf("page-spread-left") != -1) {
						item.pageSpread = Item.PAGE_SPREAD_LEFT;
					} else if (properties.indexOf("page-spread-right") != -1) {
						item.pageSpread = Item.PAGE_SPREAD_RIGHT;
					}
				}
			} else if (lName.equals("reference")) {
				Reference reference = new Reference();
				reference.href = atts.getValue("href");
				reference.fullPath = this.base.resolve(reference.href)
						.getPath();
				reference.type = atts.getValue("type");
				reference.title = atts.getValue("title");
				this.guide.add(reference);
				reference.item = (Item) this.hrefToItem.get(reference.href);
				if (reference.item != null) {
					reference.item.guide = reference;
					reference.item.title = reference.title;
				}
			}
		}
	}

	public void characters(char[] ch, int off, int len) throws SAXException {
		if (this.textBuff != null) {
			this.textBuff.append(ch, off, len);
		}
	}

	public void endElement(String uri, String lName, String qName)
			throws SAXException {
		if (this.textBuff != null) {
			String text = this.textBuff.toString();
			this.textBuff = null;
			if (uri.equals("http://purl.org/dc/elements/1.1/")) {
				if (lName.equals("title")) {
					this.contents.title = text;
				} else if (lName.equals("creator")) {
					this.contents.author = text;
				} else if (lName.equals("right")) {
					this.contents.right = text;
				} else if (lName.equals("publisher")) {
					this.contents.publisher = text;
				}
			}
		}
	}

	public Contents getContents() {
		this.contents.items = (Item[]) this.items.toArray(new Item[this.items
				.size()]);
		this.contents.spine = (Item[]) this.spine.toArray(new Item[this.spine
				.size()]);
		this.contents.guide = (Reference[]) this.guide
				.toArray(new Reference[this.spine.size()]);
		return this.contents;
	}
}
