package jp.cssj.print.epub;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.cssj.print.epub.Contents.Item;
import jp.cssj.print.epub.Toc.NavPoint;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class NCXHandler extends DefaultHandler {
	final Toc toc = new Toc();
	private StringBuffer textBuff = null;
	private boolean inText = false;
	private NavPoint navPoint;
	private final List<NavPoint> navPoints = new ArrayList<NavPoint>();
	private final Map<String, Item> fullPathToItem = new HashMap<String, Item>();
	private final URI base;

	public NCXHandler(Contents contents) {
		for (int i = 0; i < contents.spine.length; ++i) {
			Item item = contents.spine[i];
			this.fullPathToItem.put(item.fullPath, item);
		}
		this.base = URI.create(contents.toc.fullPath);
	}

	public void startElement(String uri, String lName, String qName,
			Attributes atts) throws SAXException {
		if (uri.equals("http://www.daisy.org/z3986/2005/ncx/")) {
			if (lName.equals("text")) {
				this.textBuff = new StringBuffer();
				this.inText = true;
			} else if (lName.equals("navPoint")) {
				if (this.navPoint != null) {
					this.navPoints.add(this.navPoint);
				}
				this.navPoint = new NavPoint();
				this.navPoint.id = atts.getValue("id");
				this.navPoint.playOrder = Integer.parseInt(atts
						.getValue("playOrder"));
			} else if (lName.equals("content")) {
				this.navPoint.src = atts.getValue("src");
				this.navPoint.fullPath = base.resolve(this.navPoint.src)
						.toString();
				this.navPoint.item = (Item) this.fullPathToItem
						.get(this.navPoint.fullPath);
			}
		}
	}

	public void characters(char[] ch, int off, int len) throws SAXException {
		if (this.inText) {
			this.textBuff.append(ch, off, len);
		}
	}

	public void endElement(String uri, String lName, String qName)
			throws SAXException {
		if (uri.equals("http://www.daisy.org/z3986/2005/ncx/")) {
			if (lName.equals("navPoint")) {
				if (this.navPoint != null) {
					this.navPoints.add(this.navPoint);
					this.navPoint = null;
				}
				return;
			}
			if (this.textBuff == null) {
				return;
			}
			if (lName.equals("text")) {
				this.inText = false;
				return;
			} else if (lName.equals("docTitle")) {
				this.toc.docTitle = this.textBuff.toString();
			} else if (lName.equals("navLabel")) {
				this.navPoint.label = this.textBuff.toString();
			} else {
				return;
			}
		} else {
			return;
		}
		this.textBuff = null;
	}

	public Toc getToc() {
		this.toc.navPoints = this.navPoints.toArray(new NavPoint[this.navPoints
				.size()]);
		return this.toc;
	}
}
