package jp.cssj.print.epub;

/**
 * OPFの情報です。
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 */
public class Contents {
	public static class Item {
		/** アイテムのIDです。 */
		public String id;
		/** アイテムのデータ形式です。 */
		public String mediaType;
		/** OPFからアイテムへの相対パスです。 */
		public String href;
		/** ZIPファイル内でのアイテムへのパスです。 */
		public String fullPath;
		/**
		 * アイテムの番号です。 これは、Contents.spine配列のインデックスです。
		 */
		public int index;
		/**
		 * アイテムのタイトルです。 これはガイドによるタイトルか、文書のTITLE要素の内容です。
		 */
		public String title;

		/**
		 * アイテムに対応する最初のガイドです。 ガイドが存在しない場合はnullです。
		 */
		public Reference guide;

		public static final byte PAGE_SPREAD_DEFAULT = 0;
		public static final byte PAGE_SPREAD_LEFT = 1;
		public static final byte PAGE_SPREAD_RIGHT = 2;
		/**
		 * ページの開始方向です。
		 */
		public byte pageSpread = PAGE_SPREAD_DEFAULT;
	}

	/**
	 * ガイドの要素です。
	 */
	public static class Reference {
		/** タイプ("text", "cover"など)です。 */
		public String type;
		/** タイトルです。 */
		public String title;
		/** OPFからの相対パスです。 */
		public String href;
		/** ZIPファイル内でのパスです。 */
		public String fullPath;
		/** 対応するアイテムです。 */
		public Item item;
	}

	/** OPFのZIPファイル内でのパスです。 */
	public String base;
	/** パッケージのタイトルです。 */
	public String title;
	/** パッケージの作者です。 */
	public String author;
	/** パッケージの権利情報です。 */
	public String right;
	/** パッケージの出版社です。 */
	public String publisher;

	/** 目次です。 */
	public Item toc;

	/** 全てのアイテムの配列です。 */
	public Item[] items;

	/** ページ順に並べられた本の内容の配列です。 */
	public Item[] spine;

	public static final byte PAGE_PROGRESSION_DIRECTION_DEFAULT = 0;
	public static final byte PAGE_PROGRESSION_DIRECTION_LTR = 1;
	public static final byte PAGE_PROGRESSION_DIRECTION_RTL = 2;

	public byte pageProgressionDirection = PAGE_PROGRESSION_DIRECTION_DEFAULT;

	/** ガイド情報です。 */
	public Reference[] guide;
}
