package jp.cssj.cti2.helpers;

import java.io.IOException;
import java.net.URI;

import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;

/**
 * デフォルトのデータのメタ情報です。
 * 
 * @deprecated jp.cssj.resolver.helpers.MetaSourceImplを使ってください。
 * @author <a href="miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 * @version $Id: DefaultMetaSource.java 462 2010-05-30 15:53:24Z miyabe $
 */
public class DefaultMetaSource implements MetaSource {
	private URI uri;
	private String encoding;
	private String mimeType;
	private long length;

	public DefaultMetaSource() {
		this((URI) null);
	}

	public DefaultMetaSource(URI uri) {
		this(uri, null);
	}

	public DefaultMetaSource(URI uri, String mimeType) {
		this(uri, mimeType, null);
	}

	public DefaultMetaSource(URI uri, String mimeType, String encoding) {
		this(uri, mimeType, encoding, -1L);
	}

	public DefaultMetaSource(URI uri, String mimeType, String encoding,
			long length) {
		if (uri == null) {
			uri = URIHelper.CURRENT_URI;
		}
		this.uri = uri;
		this.mimeType = mimeType;
		this.encoding = encoding;
		this.length = length;
	}

	public DefaultMetaSource(Source source) throws IOException {
		this(source.getURI(), source.getMimeType(), source.getEncoding(),
				source.getLength());
	}

	public URI getURI() {
		return this.uri;
	}

	public void setURI(URI uri) {
		this.uri = uri;
	}

	public String getEncoding() {
		return this.encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public String getMimeType() {
		return this.mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	public long getLength() {
		return this.length;
	}

	public void setLength(long length) {
		this.length = length;
	}
}
