package jp.cssj.sakae.example;

import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

import jp.cssj.rsr.impl.StreamRandomBuilder;
import jp.cssj.sakae.pdf.PdfPageOutput;
import jp.cssj.sakae.pdf.PdfWriter;
import jp.cssj.sakae.pdf.action.JavaScriptAction;
import jp.cssj.sakae.pdf.gc.PdfGC;
import jp.cssj.sakae.pdf.impl.PdfWriterImpl;
import jp.cssj.sakae.pdf.params.PdfParams;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: OpenActionDemo.java 830 2012-10-31 09:17:20Z miyabe $
 */
public class OpenActionDemo {
	public static void main(String[] args) throws Exception {
		PdfParams params = new PdfParams();
		params.setCompression(PdfParams.COMPRESSION_NONE);

		JavaScriptAction js = new JavaScriptAction("this.print();");
		params.setOpenAction(js);

		final double width = 300;
		final double height = 300;

		OutputStream out = new BufferedOutputStream(new FileOutputStream(
				"loocal/test.pdf"));
		try {
			StreamRandomBuilder builder = new StreamRandomBuilder(out);
			final PdfWriter pdf = new PdfWriterImpl(builder, params);

			PdfPageOutput page = pdf.nextPage(width, height);

			PdfGC gc = new PdfGC(page);

			{
				Rectangle2D rect = new Rectangle2D.Double(10, 10, 280, 10);
				gc.draw(rect);
			}

			page.close();

			pdf.finish();
			builder.finish();
		} finally {
			out.close();
		}
	}
}
