package jp.cssj.sakae.example;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.AttributedString;

import javax.swing.JFrame;

import jp.cssj.rsr.impl.StreamRandomBuilder;
import jp.cssj.sakae.g2d.gc.BridgeGraphics2D;
import jp.cssj.sakae.gc.text.util.TextUtils;
import jp.cssj.sakae.pdf.PdfGraphicsOutput;
import jp.cssj.sakae.pdf.PdfWriter;
import jp.cssj.sakae.pdf.gc.PdfGC;
import jp.cssj.sakae.pdf.impl.PdfWriterImpl;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: Graphics2DDemo.java 976 2013-08-09 13:00:24Z miyabe $
 */
public class Graphics2DDemo {
	public static void main(String[] args) throws Exception {
		final double width = 300;
		final double height = 300;

		OutputStream out = new BufferedOutputStream(new FileOutputStream(
				"local/test.pdf"));
		try {
			StreamRandomBuilder builder = new StreamRandomBuilder(out);
			final PdfWriter pdf = new PdfWriterImpl(builder);

			{
				// 1ページ目
				PdfGraphicsOutput page = pdf.nextPage(width, height);
				Graphics2D g = new BridgeGraphics2D(new PdfGC(page));
				draw1(g);
				page.close();

				JFrame frame = new JFrame("Graphics") {
					@Override
					public void paint(Graphics g) {
						super.paint(g);
						draw1((Graphics2D) g);
					}

				};
				frame.setSize((int) width, (int) height);
				frame.setVisible(true);
			}

			{
				// 2ページ目
				PdfGraphicsOutput page = pdf.nextPage(width, height);
				Graphics2D g = new BridgeGraphics2D(new PdfGC(page));
				draw2(g);
				page.close();

				JFrame frame = new JFrame("Graphics") {
					@Override
					public void paint(Graphics g) {
						super.paint(g);
						draw2((Graphics2D) g);
					}

				};
				frame.setSize((int) width, (int) height);
				frame.setVisible(true);
			}

			pdf.finish();
			builder.finish();
		} finally {
			out.close();
		}
	}

	private static void draw1(Graphics2D g) {
		// クリップ
		GeneralPath path = new GeneralPath();
		path.moveTo(150, 0);
		path.lineTo(20, 225);
		path.lineTo(0, 225);
		path.lineTo(0, 0);
		path.closePath();
		path.moveTo(150, 0);
		path.lineTo(280, 225);
		path.lineTo(300, 225);
		path.lineTo(300, 0);
		path.closePath();
		path.moveTo(0, 225);
		path.lineTo(300, 225);
		path.lineTo(300, 300);
		path.lineTo(0, 300);
		path.closePath();
		g.clip(path);

		// 図形描画
		g.setColor(Color.BLUE);
		g.setStroke(new BasicStroke(10, BasicStroke.CAP_BUTT,
				BasicStroke.JOIN_BEVEL, 1, new float[] { 10, 10 }, 0));
		g.drawOval(10, 10, 280, 280);
		g.setColor(Color.RED);
		AlphaComposite comp = AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				0.5f);
		g.setComposite(comp);
		g.drawRect(20, 20, 260, 260);
	}

	private static void draw2(Graphics2D g) {
		g.setFont(new Font("SansSerif", Font.PLAIN, 12));

		// 横書き
		AttributedString text = new AttributedString(
				"盗人を捕らえてみれば我が子なり\n斬りたくもあり斬りたくもなし");
		text.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, 0, 2);
		text.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, 16,
				23);
		g.drawString(text.getIterator(), 0, 12);

		// 縦書き
		text.addAttribute(TextUtils.WRITING_MODE,
				TextUtils.WRITING_MODE_VERTICAL, 0, 30);
		g.drawString(text.getIterator(), 300 - 6, 0);
	}
}
