package jp.cssj.rsr;

import java.io.IOException;

/**
 * 順次的なデータです。
 * このインターフェースを実装した RandomBuilder インスタンスでは断片の追加を必要としません。
 * 
 * @author <a href="tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Sequential.java 656 2011-09-03 15:42:28Z miyabe $
 */
public interface Sequential extends RandomBuilder {
	/**
	 * データを追加します。
	 * 
	 * @param b
	 *            バイト列。
	 * @param off
	 *            バイト列中の開始位置。
	 * @param len
	 *            バイト列中のデータの長さ。
	 * @throws IOException
	 */
	public void write(byte[] b, int off, int len) throws IOException;
}
