package jp.cssj.resolver.http;

import java.io.IOException;
import java.net.URI;

import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

/**
 * HttpClientを利用してデータを所得するSourceResolverです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: HttpSourceResolver.java 590 2011-08-28 04:43:07Z miyabe $
 */
public class HttpSourceResolver implements SourceResolver {
	protected HttpClient createHttpClient() {
		HttpClient client = new DefaultHttpClient();
		return client;
	}

	public Source resolve(URI uri) throws IOException {
		HttpClient client = this.createHttpClient();
		HttpSource source = new HttpSource(uri, client);
		return source;
	}

	public void release(Source source) {
		((HttpSource) source).close();
	}
}