package jp.cssj.resolver.helpers;

import java.io.IOException;
import java.net.URI;

import jp.cssj.resolver.Source;

/**
 * 一般的な Source の抽象クラスです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractSource.java 657 2011-09-03 15:48:03Z miyabe $
 */
public abstract class AbstractSource implements Source {
	protected final URI uri;

	public AbstractSource(URI uri) {
		this.uri = uri;
	}

	public URI getURI() {
		return this.uri;
	}

	public boolean isInputStream() throws IOException {
		return false;
	}

	public boolean isFile() throws IOException {
		return false;
	}

	public boolean isReader() throws IOException {
		return false;
	}

	public void close() {
		// ignore
	}
}
