package jp.cssj.resolver.data;

import java.io.IOException;
import java.net.URI;

import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;

/**
 * RFC2397,data:スキーマを解決するSourceResolverです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: DataSourceResolver.java 590 2011-08-28 04:43:07Z miyabe $
 */
public class DataSourceResolver implements SourceResolver {
	public Source resolve(URI uri) throws IOException {
		DataSource source = new DataSource(uri);
		return source;
	}

	public void release(Source source) {
		((DataSource) source).close();
	}
}