package net.zamasoft.font.cff;

class CffStack {
	private int size = 0;
	private final float[] values;

	public CffStack() {
		int size = 48;
		this.values = new float[size];
	}

	public void push(float value) {
		this.values[this.size] = value;
		++this.size;
	}

	public float get(int ix) {
		return this.values[ix];
	}

	public float pop() {
		return this.values[--this.size];
	}

	public void clear() {
		this.size = 0;
	}

	public void clear(int count) {
		this.size -= count;
		System.arraycopy(this.values, count, this.values, 0, this.size);
	}

	public int size() {
		return this.size;
	}
}
