package jp.cssj.sakae.svg;

import java.awt.Graphics2D;

import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.image.Image;

import org.apache.batik.gvt.GraphicsNode;

/**
 * SVG画像です。
 * 
 * @author <a href="tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: SVGImage.java 647 2011-08-28 13:05:54Z miyabe $
 */
public class SVGImage implements Image {
	protected final GraphicsNode gvtRoot;

	protected final double width, height;

	public SVGImage(GraphicsNode gvtRoot, double width, double height) {
		this.gvtRoot = gvtRoot;
		this.width = width;
		this.height = height;
	}

	public double getWidth() {
		return this.width;
	}

	public double getHeight() {
		return this.height;
	}

	public void drawTo(GC gc) throws GraphicsException {
		Graphics2D g2d = new SVGBridgeGraphics2D(gc);
		this.gvtRoot.paint(g2d);
		g2d.dispose();
	}

	public String getAltString() {
		return null;
	}
}
