package jp.cssj.sakae.pdf.impl;

import java.io.IOException;

import jp.cssj.sakae.pdf.ObjectRef;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: PagesFlow.java 647 2011-08-28 13:05:54Z miyabe $
 */
class PagesFlow {
	private final PdfWriterImpl pdfWriter;

	/** ルートページリファレンス。 */
	private final ObjectRef rootPageRef;

	/** 子ページ参照フロー。 */
	private final PdfFragmentOutputImpl pagesKidsFlow;

	/** ページ数フロー。 */
	private final PdfFragmentOutputImpl pageCountFlow;

	/** ページ数カウンタ */
	private int pageCount = 0;

	public PagesFlow(PdfWriterImpl pdfWriter, ObjectRef rootPageRef)
			throws IOException {
		this.pdfWriter = pdfWriter;
		this.rootPageRef = rootPageRef;

		PdfFragmentOutputImpl mainFlow = pdfWriter.mainFlow;
		mainFlow.startObject(rootPageRef);

		mainFlow.startHash();

		mainFlow.writeName("Type");
		mainFlow.writeName("Pages");
		mainFlow.lineBreak();

		mainFlow.writeName("Kids");
		mainFlow.startArray();
		this.pagesKidsFlow = mainFlow.forkFragment();
		mainFlow.endArray();
		mainFlow.lineBreak();

		mainFlow.writeName("Count");
		mainFlow.write(' ');
		this.pageCountFlow = mainFlow.forkFragment();
		mainFlow.lineBreak();

		mainFlow.endHash();
		mainFlow.endObject();
	}

	public PdfPageOutputImpl createPage(double width, double height)
			throws IOException {
		// ページオブジェクト
		++this.pageCount;

		return new PdfPageOutputImpl(this.pdfWriter, this.rootPageRef,
				this.pagesKidsFlow, width, height);
	}

	public void close() throws IOException {
		this.pageCountFlow.writeInt(this.pageCount);
		this.pageCountFlow.close();
		this.pagesKidsFlow.close();
	}
}
