package jp.cssj.sakae.pdf.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import jp.cssj.sakae.pdf.ObjectRef;
import jp.cssj.sakae.pdf.params.PdfParams;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: NameTreeFlow.java 647 2011-08-28 13:05:54Z miyabe $
 */
abstract class NameTreeFlow {
	public final PdfFragmentOutputImpl out;

	private final PdfWriterImpl pdfWriter;

	private final NameDictionaryFlow nameDict;

	private final String key;

	private SortedMap nameToEntry = null;

	public NameTreeFlow(PdfWriterImpl pdfWriter, String key) throws IOException {
		this.pdfWriter = pdfWriter;
		this.key = key;

		PdfFragmentOutputImpl mainFlow = pdfWriter.mainFlow;
		this.out = mainFlow.forkFragment();
		this.nameDict = pdfWriter.nameDict;
	}

	public void addEntry(String name, Object entry) {
		if (this.nameToEntry == null) {
			this.nameToEntry = new TreeMap();
		}
		this.nameToEntry.put(name, entry);
	}

	public void close() throws IOException {
		if (this.nameToEntry != null) {
			ObjectRef destsRef = this.pdfWriter.xref.nextObjectRef();
			this.nameDict.addEntry(this.key, destsRef);

			this.out.startObject(destsRef);
			this.out.startHash();

			// PDF 1.2以前ではトップレベルのNames配列がサポートされていない
			if (this.pdfWriter.params.getVersion() <= PdfParams.VERSION_1_2) {
				this.out.writeName("Kids");
				this.out.startArray();
				ObjectRef destsKidRef = this.pdfWriter.xref.nextObjectRef();
				this.out.writeObjectRef(destsKidRef);
				this.out.endArray();
				this.out.lineBreak();

				this.out.endHash();
				this.out.endObject();

				this.out.startObject(destsKidRef);
				this.out.startHash();

				this.out.writeName("Limits");
				this.out.startArray();
				this.out.writeText((String) this.nameToEntry.firstKey());
				this.out.writeText((String) this.nameToEntry.lastKey());
				this.out.endArray();
				this.out.lineBreak();
			}

			this.out.writeName("Names");
			this.out.startArray();
			for (Iterator i = this.nameToEntry.entrySet().iterator(); i
					.hasNext();) {
				Map.Entry entry = (Map.Entry) i.next();
				this.out.writeText((String) entry.getKey());
				this.writeEntry(entry.getValue());
			}
			this.out.endArray();
			this.out.lineBreak();

			this.out.endHash();
			this.out.endObject();
		}
		this.out.close();
	}

	protected abstract void writeEntry(Object entry) throws IOException;
}
