package jp.cssj.sakae.pdf.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.cssj.sakae.pdf.ObjectRef;
import jp.cssj.sakae.pdf.font.PdfFont;
import jp.cssj.sakae.pdf.font.PdfFontSource;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: FontFlow.java 647 2011-08-28 13:05:54Z miyabe $
 */
class FontFlow {
	private final XRefImpl xref;

	private final Map nameToResourceRef;

	private final PdfFragmentOutputImpl objectsFlow;

	/** FontKeyからPDFFontへのマッピング。 */
	private final Map fonts = new HashMap();
	private final List fontList = new ArrayList();

	public FontFlow(Map nameToResourceRef, PdfFragmentOutputImpl objectsFlow,
			XRefImpl xref) throws IOException {
		this.xref = xref;
		this.nameToResourceRef = nameToResourceRef;
		this.objectsFlow = objectsFlow;
	}

	public PdfFont useFont(PdfFontSource source) throws IOException {
		PdfFont font = (PdfFont) this.fonts.get(source);
		if (font != null) {
			return font;
		}
		String name = "F" + this.fonts.size();

		ObjectRef fontRef = this.xref.nextObjectRef();
		this.nameToResourceRef.put(name, fontRef);

		font = source.createFont(name, fontRef);
		this.fonts.put(source, font);
		this.fontList.add(font);
		return font;
	}

	public void close() throws IOException {
		for (int i = 0; i < this.fontList.size(); ++i) {
			PdfFont font = (PdfFont) this.fontList.get(i);
			font.writeTo(this.objectsFlow, this.xref);
		}
	}
}
