package jp.cssj.sakae.pdf.font.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.cssj.sakae.font.FontSource;

/**
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: MultimapUtils.java 647 2011-08-28 13:05:54Z miyabe $
 */
public final class MultimapUtils {
	private MultimapUtils() {
		// unused
	}

	public static void put(Map map, String key, FontSource e) {
		List list = (List) map.get(key);
		if (list == null) {
			list = new ArrayList();
			map.put(key, list);
		}
		list.add(e);
	}

	public static void putDirect(Map map, String key, FontSource e) {
		FontSource[] fonts = (FontSource[]) map.get(key);
		if (fonts == null) {
			fonts = new FontSource[] { e };
		} else {
			FontSource[] dest = new FontSource[fonts.length + 1];
			System.arraycopy(fonts, 0, dest, 0, fonts.length);
			dest[fonts.length] = e;
			fonts = dest;
		}
		map.put(key, fonts);
	}

	public static FontSource[] get(Map map, String key) {
		return (FontSource[]) map.get(key);
	}

	public static Map unmodifiableMap(Map map) {
		for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
			Map.Entry entry = (Map.Entry) i.next();
			List list = (List) entry.getValue();
			FontSource[] fonts = (FontSource[]) list
					.toArray(new FontSource[list.size()]);
			entry.setValue(fonts);
		}
		return Collections.unmodifiableMap(map);
	}
}