package jp.cssj.sakae.pdf.font.type2;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.sakae.font.BBox;
import jp.cssj.sakae.pdf.font.PdfEmbeddedFont;

public class CffGenerator {
	protected String subsetName;

	protected PdfEmbeddedFont font;

	public void setSubsetName(String subsetName) {
		this.subsetName = subsetName;
	}

	public void setEmbedableFont(PdfEmbeddedFont font) {
		this.font = font;
	}

	public void writeTo(OutputStream out) throws IOException {
		CffOutputStream cout = new CffOutputStream(out);
		BBox bbox = this.font.getBBox();

		// Header
		cout.writeHeader((byte) 1, (byte) 0, (byte) 4, (byte) 2);

		// Name INDEX
		// 名前順にソートしなければならんことに注意
		byte[][] nameIndex = { CffOutputStream.toBytes(this.subsetName) };
		cout.writeIndex(nameIndex, (byte) 1);

		int offset = cout.getOffset();

		// Top DICTの直後の内容
		byte[] afterTopDict;
		{
			ByteArrayOutputStream bout1 = new ByteArrayOutputStream();
			CffOutputStream cout1 = new CffOutputStream(bout1);
			// String INDEX
			byte[][] stringIndex = {
					CffOutputStream.toBytes(this.font.getRegistry()),
					CffOutputStream.toBytes(this.font.getOrdering()) };
			cout1.writeIndex(stringIndex, (byte) 1);

			// Global Subrs INDEX
			cout1.writeCard16((short) 0);

			cout1.close();
			afterTopDict = bout1.toByteArray();
		}

		offset += afterTopDict.length;

		ByteArrayOutputStream bout1 = new ByteArrayOutputStream();
		CffOutputStream cout1 = new CffOutputStream(bout1);

		int padding1 = 0;

		// Top DICT INDEX
		{
			ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
			CffOutputStream cout2 = new CffOutputStream(bout2);

			// ROS
			cout2.writeNSSID(0); // Registry
			cout2.writeNSSID(1); // Ordering
			cout2.writeInteger(this.font.getSupplement());
			cout2.writeOperator(CffOutputStream.ROS);

			// FontBBox
			cout2.writeInteger(bbox.llx);
			cout2.writeInteger(bbox.lly);
			cout2.writeInteger(bbox.urx);
			cout2.writeInteger(bbox.ury);
			cout2.writeOperator(CffOutputStream.FONT_BBOX);

			// CIDCount
			cout2.writeInteger(0xFFFF);
			cout2.writeOperator(CffOutputStream.CID_COUNT);

			offset += cout2.getOffset();
			offset += 5;// header
			offset += 6;// Charsets
			offset += 6;// CharStrings
			offset += 7;// FDSelect
			offset += 7;// FDArray

			// Charsets
			padding1 += 5 - cout2.writeInteger(offset + cout1.getOffset());
			cout2.writeOperator(CffOutputStream.CHARSETS);

			cout1.writeCard8((byte) 2);
			cout1.writeCard16(1);
			cout1.writeCard16(this.font.getCharCount() - 1);

			// CharStrings INDEX
			padding1 += 5 - cout2.writeInteger(offset + cout1.getOffset());
			cout2.writeOperator(CffOutputStream.CHAR_STRINGS);

			final List fonts = new ArrayList();
			for (int i = 0; i < this.font.getGlyphCount(); ++i) {
				final byte[] charString = this.font.getCharString(i);
				if (charString != null) {
					fonts.add(charString);
					continue;
				}
				final Shape shape = this.font.getShape(i);
				if (shape == null) {
					fonts.add(Type2OutputStream.ENDCHAR);
					continue;
				}
				final ByteArrayOutputStream bout3 = new ByteArrayOutputStream();
				final Type2OutputStream tout3 = new Type2OutputStream(bout3);
				final PathIterator j = shape.getPathIterator(null);
				double cx = 0, cy = 0;
				boolean closed = true;
				final double[] cord = new double[6];
				LOOP: while (!j.isDone()) {
					int type = j.currentSegment(cord);
					switch (type) {
					case PathIterator.SEG_MOVETO: {
						double x = cord[0];
						double y = -cord[1];
						short dx = (short) Math.round(x - cx);
						short dy = (short) Math.round(y - cy);
						if (dx == 0) {
							tout3.writeShort(dy);
							tout3.writeOperator(Type2OutputStream.VMOVETO);
							cy += dy;
						} else if (dy == 0) {
							tout3.writeShort(dx);
							tout3.writeOperator(Type2OutputStream.HMOVETO);
							cx += dx;
						} else {
							tout3.writeShort(dx);
							tout3.writeShort(dy);
							tout3.writeOperator(Type2OutputStream.RMOVETO);
							cx += dx;
							cy += dy;
						}
						closed = false;
					}
						break;

					case PathIterator.SEG_LINETO: {
						if (closed) {
							tout3.writeShort((short) 0);
							tout3.writeOperator(Type2OutputStream.HMOVETO);
							closed = false;
						}
						double x = cord[0];
						double y = -cord[1];
						short dx = (short) Math.round(x - cx);
						short dy = (short) Math.round(y - cy);
						if (dx == 0) {
							tout3.writeShort(dy);
							tout3.writeOperator(Type2OutputStream.VLINETO);
							cy += dy;
						} else if (dy == 0) {
							tout3.writeShort(dx);
							tout3.writeOperator(Type2OutputStream.HLINETO);
							cx += dx;
						} else {
							tout3.writeShort(dx);
							tout3.writeShort(dy);
							tout3.writeOperator(Type2OutputStream.RLINETO);
							cx += dx;
							cy += dy;
						}
					}
						break;

					case PathIterator.SEG_QUADTO: {
						if (closed) {
							tout3.writeShort((short) 0);
							tout3.writeOperator(Type2OutputStream.HMOVETO);
							closed = false;
						}
						double x1 = cord[0];
						double y1 = -cord[1];
						double x2 = cord[2];
						double y2 = -cord[3];
						double xa = (cx + 2f * (x1 - cx) / 3f);
						double ya = (cy + 2f * (y1 - cy) / 3f);
						double xb = (xa + (x2 - cx) / 3f);
						double yb = (ya + (y2 - cy) / 3f);
						double xc = x2;
						double yc = y2;
						short dxa = (short) Math.round(xa - cx);
						short dya = (short) Math.round(ya - cy);
						cx += dxa;
						cy += dya;
						short dxb = (short) Math.round(xb - cx);
						short dyb = (short) Math.round(yb - cy);
						cx += dxb;
						cy += dyb;
						short dxc = (short) Math.round(xc - cx);
						short dyc = (short) Math.round(yc - cy);
						cx += dxc;
						cy += dyc;
						tout3.writeShort(dxa);
						tout3.writeShort(dya);
						tout3.writeShort(dxb);
						tout3.writeShort(dyb);
						tout3.writeShort(dxc);
						tout3.writeShort(dyc);
						tout3.writeOperator(Type2OutputStream.RRCURVETO);
					}
						break;

					case PathIterator.SEG_CUBICTO: {
						if (closed) {
							tout3.writeShort((short) 0);
							tout3.writeOperator(Type2OutputStream.HMOVETO);
							closed = false;
						}
						double xa = cord[0];
						double ya = -cord[1];
						double xb = cord[2];
						double yb = -cord[3];
						double xc = cord[4];
						double yc = -cord[5];
						short dxa = (short) Math.round(xa - cx);
						short dya = (short) Math.round(ya - cy);
						cx += dxa;
						cy += dya;
						short dxb = (short) Math.round(xb - cx);
						short dyb = (short) Math.round(yb - cy);
						cx += dxb;
						cy += dyb;
						short dxc = (short) Math.round(xc - cx);
						short dyc = (short) Math.round(yc - cy);
						cx += dxc;
						cy += dyc;
						tout3.writeShort(dxa);
						tout3.writeShort(dya);
						tout3.writeShort(dxb);
						tout3.writeShort(dyb);
						tout3.writeShort(dxc);
						tout3.writeShort(dyc);
						tout3.writeOperator(Type2OutputStream.RRCURVETO);
						cx = xc;
						cy = yc;
					}
						break;

					case PathIterator.SEG_CLOSE:
						j.next();
						if (j.isDone()) {
							break LOOP;
						}
						closed = true;
						continue;
					}
					j.next();
				}
				tout3.writeOperator(Type2OutputStream.ENDCHAR);
				tout3.close();

				fonts.add(bout3.toByteArray());
			}
			cout1.writeIndex(
					(byte[][]) fonts.toArray(new byte[fonts.size()][]),
					(byte) 4);

			// FDSelect
			padding1 += 5 - cout2.writeInteger(offset + cout1.getOffset());
			cout2.writeOperator(CffOutputStream.FD_SELECT);

			cout1.writeCard8((byte) 3);
			cout1.writeCard16((short) 1);
			cout1.writeCard16((short) 0);
			cout1.writeCard8((byte) 0);
			cout1.writeCard16((short) this.font.getGlyphCount());

			// Font DICT INDEX
			padding1 += 5 - cout2.writeInteger(offset + cout1.getOffset());
			cout2.writeOperator(CffOutputStream.FD_ARRAY);

			{
				ByteArrayOutputStream bout3 = new ByteArrayOutputStream();
				CffOutputStream cout3 = new CffOutputStream(bout3);

				// Private DICT
				byte[] privateDict;
				{
					ByteArrayOutputStream bout4 = new ByteArrayOutputStream();
					CffOutputStream cout4 = new CffOutputStream(bout4);
					cout4.writeInteger(1);
					cout4.writeOperator(CffOutputStream.LANGUAGE_GROUP);

					cout4.close();
					privateDict = bout4.toByteArray();
				}

				cout3.writeInteger(privateDict.length);
				int padding2 = 5 - cout3.writeInteger(offset
						+ cout1.getOffset() + 5 + cout3.getOffset() + 6);
				cout3.writeOperator(CffOutputStream.PRIVATE);

				cout3.close();
				cout1.writeIndex(new byte[][] { bout3.toByteArray() }, (byte) 1);

				// 参照を合わすための埋め立て
				for (int i = 0; i < padding2; ++i) {
					cout1.write(0);
				}

				cout1.write(privateDict);
			}

			cout2.close();
			cout.writeIndex(new byte[][] { bout2.toByteArray() }, (byte) 1);
		}

		cout.write(afterTopDict);

		// 参照を合わすための埋め立て
		for (int i = 0; i < padding1; ++i) {
			cout.write(0);
		}

		cout1.close();
		cout.write(bout1.toByteArray());

		cout.flush();
	}
}
