package jp.cssj.sakae.pdf.font.type1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.cssj.resolver.Source;
import jp.cssj.sakae.pdf.font.type1.AFMFontInfo.AFMGlyphInfo;
import jp.cssj.sakae.util.IntList;
import jp.cssj.sakae.util.ShortList;

/**
 * Type1シンボリックフォントです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: SymbolicType1FontSource.java 660 2011-09-06 12:31:37Z miyabe $
 */
public class SymbolicType1FontSource extends AbstractType1FontSource {
	private static final Logger LOG = Logger
			.getLogger(SymbolicType1FontSource.class.getName());

	private static final long serialVersionUID = 0;

	private final Source toUnicodeFile;

	transient private SoftReference charToGid = null;

	transient private SoftReference gidToGi = null;

	public SymbolicType1FontSource(AFMFontInfo fontInfo, Source toUnicodeFile)
			throws IOException {
		super(fontInfo);
		this.toUnicodeFile = toUnicodeFile;
		if (LOG.isLoggable(Level.FINE)) {
			LOG.fine("new font: " + this.getFontName());
		}
	}

	protected synchronized GlyphInfo[] getGidToGi() {
		GlyphInfo[] gidToGi = null;
		if (this.gidToGi != null) {
			gidToGi = (GlyphInfo[]) this.gidToGi.get();
			if (gidToGi != null) {
				return gidToGi;
			}
		}
		if (LOG.isLoggable(Level.FINE)) {
			LOG.fine("build gidToGi: " + this.getFontName());
		}
		gidToGi = new GlyphInfo[256];
		for (Iterator<AFMGlyphInfo> i = this.fontInfo.nameToGi.values()
				.iterator(); i.hasNext();) {
			AFMGlyphInfo aci = (AFMGlyphInfo) i.next();
			if (aci.gid == -1) {
				continue;
			}

			IntList sgidToLigature;
			if (aci.nameToLigature != null) {
				sgidToLigature = new IntList(-1);
				for (Iterator j = aci.nameToLigature.entrySet().iterator(); j
						.hasNext();) {
					Entry e = (Entry) j.next();
					AFMGlyphInfo sci = (AFMGlyphInfo) this.fontInfo.nameToGi
							.get(e.getKey());
					AFMGlyphInfo lci = (AFMGlyphInfo) this.fontInfo.nameToGi
							.get(e.getValue());
					sgidToLigature.set(sci.gid, lci.gid);
				}
				if (sgidToLigature.isEmpty()) {
					sgidToLigature = null;
				} else {
					sgidToLigature.pack();
				}
			} else {
				sgidToLigature = null;
			}
			ShortList sgidToKerning;
			if (aci.nameToKerning != null) {
				sgidToKerning = new ShortList();
				for (Iterator j = aci.nameToKerning.entrySet().iterator(); j
						.hasNext();) {
					Entry e = (Entry) j.next();
					Short kerning = (Short) e.getValue();
					AFMGlyphInfo sci = (AFMGlyphInfo) this.fontInfo.nameToGi
							.get(e.getKey());
					sgidToKerning.set(sci.gid, kerning.shortValue());
				}
				if (sgidToKerning.isEmpty()) {
					sgidToKerning = null;
				} else {
					sgidToKerning.pack();
				}
			} else {
				sgidToKerning = null;
			}

			gidToGi[aci.gid] = new GlyphInfo(aci.advance,
					sgidToLigature == null ? null : sgidToLigature.toArray(),
					sgidToKerning == null ? null : sgidToKerning.toArray());
		}
		this.gidToGi = new SoftReference(gidToGi);
		return gidToGi;
	}

	private synchronized IntList getCharToGid() {
		IntList charToGid = null;
		synchronized (this) {
			if (this.charToGid != null) {
				charToGid = (IntList) this.charToGid.get();
				if (charToGid != null) {
					return charToGid;
				}
			}
		}
		if (LOG.isLoggable(Level.FINE)) {
			LOG.fine("build charToGid: " + this.getFontName());
		}
		charToGid = new IntList(-1);
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(
					this.toUnicodeFile.getInputStream(), "ISO-8859-1"));
			try {
				for (String line = in.readLine(); line != null; line = in
						.readLine()) {
					if (line.startsWith("#")) {
						continue;
					}
					String[] pair = line.split("\t");
					if (pair.length < 2) {
						continue;
					}
					int unicode = Integer.parseInt(pair[0].trim(), 16);
					int gid = Integer.parseInt(pair[1].trim(), 16);
					charToGid.set(unicode, gid);
				}
				charToGid.pack();
			} finally {
				in.close();
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		this.charToGid = new SoftReference(charToGid);
		return charToGid;
	}

	int toGID(int c) {
		int gid = this.getCharToGid().get(c);
		return gid;
	}

	String getEncoding() {
		return null;
	}
}
