package jp.cssj.sakae.pdf.font.type1;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.sakae.font.AbstractFontSource;
import jp.cssj.sakae.font.BBox;
import jp.cssj.sakae.gc.font.FontStyle;
import jp.cssj.sakae.pdf.ObjectRef;
import jp.cssj.sakae.pdf.font.PdfFont;
import jp.cssj.sakae.pdf.font.PdfFontSource;
import jp.cssj.sakae.pdf.font.type1.AFMFontInfo.AFMGlyphInfo;
import jp.cssj.sakae.pdf.font.util.PdfFontUtils;

/**
 * 標準Type1フォントです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractType1FontSource.java 647 2011-08-28 13:05:54Z miyabe $
 */
public abstract class AbstractType1FontSource extends AbstractFontSource
		implements PdfFontSource {
	private static final long serialVersionUID = 1L;

	protected final AFMFontInfo fontInfo;

	private final BBox bbox;

	private final short spaceAdvance;

	transient protected Font awtFont = null;

	protected AbstractType1FontSource(AFMFontInfo fontInfo) {
		this.fontInfo = fontInfo;

		List aliases = new ArrayList();
		if (fontInfo.familyName != null) {
			aliases.add(fontInfo.familyName);
		}
		if (fontInfo.fullName != null) {
			aliases.add(fontInfo.fullName);
		}
		this.aliases = (String[]) aliases.toArray(new String[aliases.size()]);

		this.isItalic = fontInfo.italic;
		this.weight = fontInfo.weight;
		this.bbox = fontInfo.bbox;
		this.spaceAdvance = ((AFMGlyphInfo) fontInfo.nameToGi.get("space")).advance;
	}

	protected abstract GlyphInfo[] getGidToGi();

	protected synchronized Font getAwtFont() {
		if (this.awtFont == null) {
			this.awtFont = PdfFontUtils.toAwtFont(this);
		}
		return this.awtFont;
	}

	public byte getDirection() {
		return FontStyle.DIRECTION_LTR;
	}

	public String getFontName() {
		return this.fontInfo.fontName;
	}

	public byte getType() {
		return TYPE_CORE;
	}

	short getAdvance(int gid) {
		if (!this.canDisplayGID(gid)) {
			return 0;
		}
		GlyphInfo gi = this.getGidToGi()[gid];
		return gi.advance;
	}

	short getKerning(int gid, int pgid) {
		if (!this.canDisplayGID(gid)) {
			return 0;
		}
		GlyphInfo gi = this.getGidToGi()[gid];
		return gi.getKerning(pgid);
	}

	int getLigature(int gid, int pgid) {
		if (!this.canDisplayGID(gid)) {
			return -1;
		}
		GlyphInfo gi = this.getGidToGi()[gid];
		return gi.getLigature(pgid);
	}

	abstract int toGID(int c);

	abstract String getEncoding();

	public boolean canDisplay(int c) {
		int gid = this.toGID(c);
		return this.canDisplayGID(gid);
	}

	private boolean canDisplayGID(int gid) {
		if (gid < 0 || gid >= this.getGidToGi().length) {
			return false;
		}
		GlyphInfo gi = this.getGidToGi()[gid];
		if (gi == null) {
			return false;
		}
		return true;
	}

	/**
	 * @return this.Returns the bbox.
	 */
	public BBox getBBox() {
		return this.bbox;
	}

	/**
	 * @return this.Returns the ascent.
	 */
	public short getAscent() {
		return this.fontInfo.ascent;
	}

	/**
	 * @return this.Returns the capHeight.
	 */
	public short getCapHeight() {
		return this.fontInfo.capHeight;
	}

	/**
	 * @return this.Returns the descent.
	 */
	public short getDescent() {
		return this.fontInfo.descent;
	}

	/**
	 * @return this.Returns the stemh.
	 */
	public short getStemH() {
		return this.fontInfo.stemh;
	}

	/**
	 * @return this.Returns the stemv.
	 */
	public short getStemV() {
		return this.fontInfo.stemv;
	}

	/**
	 * @return this.Returns the xHeight.
	 */
	public short getXHeight() {
		return this.fontInfo.xHeight;
	}

	public short getSpaceAdvance() {
		return this.spaceAdvance;
	}

	public PdfFont createFont(String name, ObjectRef fontRef) {
		return new Type1Font(this, name, this.getEncoding(), fontRef);
	}

	public jp.cssj.sakae.font.Font createFont() {
		return this.createFont(null, null);
	}
}
