package jp.cssj.sakae.pdf.font.cid.keyed;

import java.awt.Font;

import jp.cssj.sakae.pdf.font.cid.CIDTable;
import jp.cssj.sakae.pdf.font.cid.CMap;
import jp.cssj.sakae.pdf.font.cid.WArray;
import jp.cssj.sakae.pdf.font.cid.identity.SystemCIDIdentityFontSource;
import jp.cssj.sakae.util.ShortList;

/**
 * 等幅の一般フォントです。 このフォントはプラットフォームによって書体が変わります。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: GenericType0FontFace.java,v 1.2 2005/06/06 04:42:24 harumanx
 *          Exp $
 */
public class SystemCIDKeyedFontSource extends CIDKeyedFontSource {
	private static final long serialVersionUID = 0L;

	protected final Font awtFont;

	public SystemCIDKeyedFontSource(CMap hcmap, CMap vcmap, Font awtFont) {
		super(hcmap, vcmap);
		this.awtFont = awtFont = awtFont.deriveFont(1000f);
		SystemCIDIdentityFontSource fs = new SystemCIDIdentityFontSource(
				awtFont);
		this.fontName = fs.getFontName();
		this.aliases = fs.getAliases();
		this.bbox = fs.getBBox();
		this.ascent = fs.getAscent();
		this.descent = fs.getDescent();
		this.capHeight = fs.getCapHeight();
		this.xHeight = fs.getXHeight();
		this.panose = fs.getPanose();
	}

	public Font getAwtFont() {
		return this.awtFont;
	}

	public WArray getWArray() {
		if (this.warray == null) {
			SystemCIDIdentityFontSource fs = new SystemCIDIdentityFontSource(
					this.awtFont);
			this.setWArray(systemWArray(fs, this.hcmap));
		}
		return this.warray;
	}

	private static WArray systemWArray(SystemCIDIdentityFontSource fs, CMap cmap) {
		ShortList cidToAdvance = new ShortList(Short.MIN_VALUE);
		CIDTable ct = cmap.getCIDTable();
		for (int i = 0; i < ct.getLength(); ++i) {
			if (!ct.containsChar(i)) {
				continue;
			}
			int cid = ct.toCID(i);
			int gid = fs.toGID(i);
			short advance = (short) fs.getWidth(gid);
			cidToAdvance.set(cid, advance);
		}
		WArray warray = WArray.buildFromWidths(cidToAdvance.toArray());
		return warray;
	}
}
