package jp.cssj.sakae.pdf.font.cid.keyed;

import java.io.File;
import java.io.IOException;

import jp.cssj.sakae.font.FontSource;
import jp.cssj.sakae.pdf.font.cid.CIDTable;
import jp.cssj.sakae.pdf.font.cid.CMap;
import jp.cssj.sakae.pdf.font.cid.WArray;
import jp.cssj.sakae.pdf.font.cid.identity.OpenTypeCIDIdentityFontSource;
import jp.cssj.sakae.util.ShortList;
import net.zamasoft.font.OpenTypeFont;
import net.zamasoft.font.table.Table;
import net.zamasoft.font.table.XmtxTable;

/**
 * 等幅の一般フォントです。 このフォントはプラットフォームによって書体が変わります。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: GenericType0FontFace.java,v 1.2 2005/06/06 04:42:24 harumanx
 *          Exp $
 */
public class OpenTypeCIDKeyedFontSource extends CIDKeyedFontSource {
	private static final long serialVersionUID = 1L;

	protected final File otFile;

	protected final int index;

	public OpenTypeCIDKeyedFontSource(CMap hcmap, CMap vcmap, File otFile,
			int index) throws IOException {
		super(hcmap, vcmap);
		this.otFile = otFile;
		this.index = index;
		OpenTypeCIDIdentityFontSource fs = new OpenTypeCIDIdentityFontSource(
				this.otFile, this.index, this.getDirection());
		this.fontName = fs.getFontName();
		this.aliases = fs.getAliases();
		this.bbox = fs.getBBox();
		this.ascent = fs.getAscent();
		this.descent = fs.getDescent();
		this.capHeight = fs.getCapHeight();
		this.xHeight = fs.getXHeight();
		this.stemH = fs.getStemH();
		this.stemV = fs.getStemV();
		this.panose = fs.getPanose();
	}

	public WArray getWArray() {
		if (this.warray == null) {
			try {
				OpenTypeCIDIdentityFontSource fs = new OpenTypeCIDIdentityFontSource(
						this.otFile, this.index, this.getDirection());
				this.setWArray(otWArray(fs, this.hcmap));
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
		return this.warray;
	}

	private static WArray otWArray(OpenTypeCIDIdentityFontSource fs, CMap cmap) {
		OpenTypeFont otFont = fs.getOpenTypeFont();
		XmtxTable hmtx = (XmtxTable) otFont.getTable(Table.hmtx);
		short upm = fs.getUnitsPerEm();

		ShortList cidToAdvance = new ShortList(Short.MIN_VALUE);
		CIDTable ct = cmap.getCIDTable();
		for (int i = 0; i < ct.getLength(); ++i) {
			if (!ct.containsChar(i)) {
				continue;
			}
			int cid = ct.toCID(i);
			int gid = fs.getCmapFormat().mapCharCode(i);
			short advance = (short) (hmtx.getAdvanceWidth(gid)
					* FontSource.UNITS_PER_EM / upm);
			// CIDは重複することがあるので、広い方の幅を採用する
			if (advance > cidToAdvance.get(cid)) {
				cidToAdvance.set(cid, advance);
			}
		}
		WArray warray = WArray.buildFromWidths(cidToAdvance.toArray());
		return warray;
	}
}
