package jp.cssj.sakae.pdf.font.cid.embedded;

import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.sakae.font.BBox;
import jp.cssj.sakae.font.otf.OpenTypeFont;
import jp.cssj.sakae.font.otf.OpenTypeFontSource;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.font.util.FontUtils;
import jp.cssj.sakae.gc.text.Text;
import jp.cssj.sakae.pdf.ObjectRef;
import jp.cssj.sakae.pdf.PdfFragmentOutput;
import jp.cssj.sakae.pdf.XRef;
import jp.cssj.sakae.pdf.font.PdfEmbeddedFont;
import jp.cssj.sakae.pdf.font.cid.CIDUtils;
import jp.cssj.sakae.pdf.font.util.PdfFontUtils;
import jp.cssj.sakae.pdf.gc.PdfGC;
import jp.cssj.sakae.util.CharList;
import jp.cssj.sakae.util.IntList;
import jp.cssj.sakae.util.ShortList;
import net.zamasoft.font.Glyph;

class OpenTypeEmbeddedCIDFont extends OpenTypeFont implements PdfEmbeddedFont {
	private static final long serialVersionUID = 0L;

	protected final ObjectRef fontRef;

	protected final String name;

	protected final ShortList widths = new ShortList(Short.MIN_VALUE),
			heights = new ShortList(Short.MIN_VALUE);

	protected IntList gids = new IntList(-1);

	protected CharList unicodes = new CharList();

	protected final List<Glyph> glyphs = new ArrayList<Glyph>();

	protected OpenTypeEmbeddedCIDFont(OpenTypeEmbeddedCIDFontSource source,
			String name, ObjectRef fontRef) {
		super(source);
		this.fontRef = fontRef;
		this.name = name;
		this.widths.set(0, (short) this.getHAdvance(0));
		this.heights.set(0, (short) this.getVAdvance(0));
		this.glyphs.add(source.getOpenTypeFont().getGlyph(0));
	}

	public String getName() {
		return this.name;
	}

	public int toGID(int c) {
		OpenTypeEmbeddedCIDFontSource source = (OpenTypeEmbeddedCIDFontSource) this
				.getFontSource();
		int agid = source.getCmapFormat().mapCharCode(c);
		if (agid == 0) {
			return 0;
		}
		int gid = this.gids.get(c);
		if (gid == -1) {
			gid = this.glyphs.size();
			this.gids.set(c, gid);
			this.unicodes.set(gid, (char) c);

			if (this.vSubst != null) {
				agid = this.vSubst.substitute(agid);
			}
			Glyph g = source.getOpenTypeFont().getGlyph(agid);
			this.glyphs.add(g);

			this.widths.set(gid, this.getHAdvance(agid));
			this.heights.set(gid, this.getVAdvance(agid));
		}
		return gid;
	}
	
	protected int toChar(int gid) {
		return this.unicodes.get(gid);
	}

	public Shape getShapeByGID(int gid) {
		OpenTypeFontSource source = (OpenTypeFontSource) this.getFontSource();
		int agid = source.getCmapFormat().mapCharCode(this.unicodes.get(gid));
		if (this.vSubst != null) {
			agid = this.vSubst.substitute(agid);
		}
		Glyph glyph = source.getOpenTypeFont().getGlyph(agid);
		if (glyph == null) {
			return null;
		}
		Shape shape = glyph.getPath();
		if (ADJUST_VERTICAL) {
			if (this.isVertical()) {
				double advance = this.getAdvance(gid);
				shape = this.adjustShape(shape, advance);
			}
		}
		return shape;
	}

	public short getAdvance(int gid) {
		if (this.isVertical()) {
			return this.heights.get(gid);
		}
		return this.widths.get(gid);
	}

	public short getWidth(int gid) {
		return this.widths.get(gid);
	}

	public void drawTo(GC gc, Text text) throws IOException, GraphicsException {
		if (gc instanceof PdfGC) {
			PdfFontUtils.drawCIDTo(((PdfGC) gc).getPDFGraphicsOutput(), text,
					this.vSubst != null);
		} else {
			FontUtils.drawPDFFont(gc, this, text);
		}
	}

	public void writeTo(PdfFragmentOutput out, XRef xref) throws IOException {
		OpenTypeEmbeddedCIDFontSource source = (OpenTypeEmbeddedCIDFontSource) this
				.getFontSource();
		final char[] unicodea = this.unicodes.toArray();
		this.unicodes = null;
		final short[] w = this.widths.toArray();
		final short[] w2;
		if (this.vSubst != null) {
			w2 = this.heights.toArray();
		} else {
			w2 = null;
		}
		
		CIDUtils.writeEmbeddedFont(out, xref, source, this, this.fontRef, w,
				w2, unicodea);
	}

	public BBox getBBox() {
		OpenTypeEmbeddedCIDFontSource source = (OpenTypeEmbeddedCIDFontSource) this
				.getFontSource();
		return source.getBBox();
	}

	public int getGlyphCount() {
		return this.glyphs.size();
	}

	public int getCharCount() {
		return this.glyphs.size();
	}

	public String getOrdering() {
		return CIDUtils.ORDERING;
	}

	public String getRegistry() {
		return CIDUtils.REGISTRY;
	}

	public Shape getShape(int gid) {
		final Glyph glyph = (Glyph) this.glyphs.get(gid);
		if (glyph == null) {
			return null;
		}
		Shape shape = glyph.getPath();
		if (ADJUST_VERTICAL) {
			if (this.isVertical()) {
				double advance = this.getAdvance(gid);
				shape = this.adjustShape(shape, advance);
			}
		}
		return shape;
	}

	public byte[] getCharString(int gid) {
		Glyph glyph = (Glyph) this.glyphs.get(gid);
		if (glyph == null) {
			return null;
		}
		return glyph.getCharString();
	}

	public int getSupplement() {
		return CIDUtils.SUPPLEMENT;
	}

	public String getPSName() {
		OpenTypeEmbeddedCIDFontSource metaFont = (OpenTypeEmbeddedCIDFontSource) this
				.getFontSource();
		return metaFont.getFontName();
	}
}
