package jp.cssj.sakae.pdf.font.cid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: ToUnicode.java 647 2011-08-28 13:05:54Z miyabe $
 */
public class ToUnicode implements Serializable {
	private static final long serialVersionUID = 0;

	protected final Unicode[] unicodes;

	public ToUnicode(Unicode[] unicodes) {
		this.unicodes = unicodes;
	}

	public Unicode[] getUnicodes() {
		return this.unicodes;
	}

	public static class Unicode implements Serializable {
		private static final long serialVersionUID = 0;

		/** 最初のコードと最後のコードです。 */
		int firstCode, lastCode;

		/** 文字のリストです。 */
		char[] unicodes;

		/**
		 * ある範囲の文字に対するエントリを構築します。
		 * 
		 * @param firstCode
		 *            最初の文字のコード。
		 * @param lastCode
		 *            最後の文字のコード。
		 * @param widths
		 *            文字の幅のリスト。
		 */
		public Unicode(int firstCode, int lastCode, char[] unicodes) {
			this.firstCode = firstCode;
			this.lastCode = lastCode;
			this.unicodes = unicodes;
		}

		public Unicode(int code, char[] unicodes) {
			this(code, code, unicodes);
		}

		public Unicode(char[] unicodes) {
			this(0, 0, unicodes);
		}

		public int getFirstCode() {
			return this.firstCode;
		}

		public int getLastCode() {
			return this.lastCode;
		}

		public char[] getUnicodes() {
			return this.unicodes;
		}

		public char getUnicode(int code) {
			if (code < this.firstCode || code > this.lastCode) {
				throw new ArrayIndexOutOfBoundsException(code);
			}
			int index = code - this.firstCode;
			if (index >= this.unicodes.length) {
				return this.unicodes[this.unicodes.length - 1];
			}
			return this.unicodes[index];
		}
	}

	/**
	 * 文字配列から最適なToUnicodeを構築します。
	 * 
	 * @param unicodes
	 * @return
	 */
	public static ToUnicode buildFromChars(char[] unicodes) {
		List list = new ArrayList();
		char[] runUnicodes = new char[256];
		int position = 0;
		int startCid = -1;
		for (int cid = 0; cid < unicodes.length; ++cid) {
			char unicode = unicodes[cid];
			if (unicode == 0) {
				if (position == 0) {
					continue;
				}
				unicode = (char) (runUnicodes[position - 1] + (cid - startCid));
			}

			if (startCid == -1) {
				// 最初
				startCid = cid;
				runUnicodes[position++] = unicode;
				continue;
			} else if (cid % 256 != 0) {// SPEC PDF 7.10.1 (ランはバイトをまたがることができない)
				runUnicodes[position++] = unicode;
				continue;
			}
			// ランの終了
			char[] temp = new char[position];
			System.arraycopy(runUnicodes, 0, temp, 0, position);
			list.add(new ToUnicode.Unicode(startCid, cid - 1, temp));
			startCid = cid;
			runUnicodes[0] = unicode;
			position = 1;
		}
		if (startCid != -1) {
			char[] temp = new char[position];
			System.arraycopy(runUnicodes, 0, temp, 0, position);
			list.add(new ToUnicode.Unicode(startCid, unicodes.length - 1, temp));
		}
		return new ToUnicode(
				(ToUnicode.Unicode[]) list.toArray(new ToUnicode.Unicode[list
						.size()]));
	}
}
