package jp.cssj.sakae.pdf.font.cid;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

import jp.cssj.sakae.font.AbstractFontSource;
import jp.cssj.sakae.font.BBox;
import jp.cssj.sakae.gc.font.FontStyle;
import jp.cssj.sakae.gc.font.Panose;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: SystemCIDFontSource.java 647 2011-08-28 13:05:54Z miyabe $
 */
public abstract class SystemCIDFontSource extends AbstractFontSource implements
		CIDFontSource {
	private static final long serialVersionUID = 1L;

	private static final char[] X = new char[] { 'x' };

	private static final char[] H = new char[] { 'H' };

	private static final char[] S = new char[] { ' ' };

	protected final Font awtFont;

	protected String fontName;

	protected final BBox bbox;

	protected final short ascent, descent, xHeight, capHeight, spaceAdvance;

	protected Panose panose = null;

	public SystemCIDFontSource(Font awtFont) {
		this.awtFont = awtFont = awtFont.deriveFont(1000f);

		// フォントメトリック情報
		Rectangle2D bounds = awtFont.getMaxCharBounds(this
				.getFontRenderContext());
		BBox bbox = new BBox((short) bounds.getX(), (short) -bounds.getMaxY(),
				(short) bounds.getMaxX(), (short) -bounds.getY());

		this.fontName = awtFont.getFontName();
		this.aliases = new String[] { awtFont.getFamily(), awtFont.getPSName() };
		this.setItalic(awtFont.isItalic());
		Float weight = (Float) awtFont.getAttributes()
				.get(TextAttribute.WEIGHT);
		double rweight;
		if (weight != null) {
			rweight = Math.max(weight.doubleValue(),
					TextAttribute.WEIGHT_EXTRA_LIGHT.doubleValue());
		} else {
			rweight = TextAttribute.WEIGHT_MEDIUM.doubleValue();
		}
		rweight = Math.min(rweight,
				TextAttribute.WEIGHT_ULTRABOLD.doubleValue());
		rweight = (rweight - TextAttribute.WEIGHT_EXTRA_LIGHT.doubleValue())
				/ (TextAttribute.WEIGHT_ULTRABOLD.doubleValue() - TextAttribute.WEIGHT_EXTRA_LIGHT
						.doubleValue());
		if (rweight <= 0.1) {
			this.setWeight((short) 100);
		} else if (rweight <= 0.2) {
			this.setWeight((short) 200);
		} else if (rweight <= 0.3) {
			this.setWeight((short) 300);
		} else if (rweight <= 0.4) {
			this.setWeight((short) 400);
		} else if (rweight <= 0.5) {
			this.setWeight((short) 500);
		} else if (rweight <= 0.6) {
			this.setWeight((short) 600);
		} else if (rweight <= 0.7) {
			this.setWeight((short) 700);
		} else if (rweight <= 0.8) {
			this.setWeight((short) 800);
		} else {
			this.setWeight((short) 900);
		}

		this.bbox = bbox;
		if (awtFont.canDisplay('H') || awtFont.canDisplay('x')) {
			LineMetrics lm = awtFont.getLineMetrics("Hx",
					this.getFontRenderContext());
			this.ascent = (short) lm.getAscent();
			this.descent = (short) lm.getDescent();
		} else {
			this.ascent = DEFAULT_ASCENT;
			this.descent = DEFAULT_DESCENT;
		}

		if (awtFont.canDisplay('x')) {
			GlyphVector gv = awtFont.createGlyphVector(
					this.getFontRenderContext(), X);
			this.xHeight = (short) gv.getVisualBounds().getHeight();
		} else {
			this.xHeight = DEFAULT_X_HEIGHT;
		}
		if (awtFont.canDisplay('H')) {
			GlyphVector gv = awtFont.createGlyphVector(
					this.getFontRenderContext(), H);
			this.capHeight = (short) gv.getVisualBounds().getHeight();
		} else {
			this.capHeight = DEFAULT_CAP_HEIGHT;
		}
		GlyphVector gv = awtFont.createGlyphVector(this.getFontRenderContext(),
				S);
		this.spaceAdvance = (short) gv.getGlyphMetrics(0).getAdvance();
	}

	public byte getDirection() {
		return FontStyle.DIRECTION_LTR;
	}

	public Font getAwtFont() {
		return this.awtFont;
	}

	public void setFontName(String fontName) {
		this.fontName = fontName;
	}

	public Panose getPanose() {
		return this.panose;
	}

	public void setPanose(Panose panose) {
		this.panose = panose;
	}

	public FontRenderContext getFontRenderContext() {
		return SystemFontRenderContext.SHARED_INSTANCE;
	}

	public BBox getBBox() {
		return this.bbox;
	}

	public String getFontName() {
		return this.fontName;
	}

	public short getXHeight() {
		return this.xHeight;
	}

	public short getSpaceAdvance() {
		return this.spaceAdvance;
	}

	public short getCapHeight() {
		return this.capHeight;
	}

	public short getAscent() {
		return this.ascent;
	}

	public short getDescent() {
		return this.descent;
	}

	public short getStemH() {
		return 0;
	}

	public short getStemV() {
		return 0;
	}

	public boolean canDisplay(int c) {
		return this.awtFont.canDisplay((char) c);
	}
}

class SystemFontRenderContext extends FontRenderContext implements Serializable {
	private static final long serialVersionUID = 0;

	public static final SystemFontRenderContext SHARED_INSTANCE = new SystemFontRenderContext(
			new AffineTransform(), true, true);

	private SystemFontRenderContext(AffineTransform tx, boolean isAntiAliased,
			boolean usesFractionalMetrics) {
		super(tx, isAntiAliased, usesFractionalMetrics);
	}
}
