package jp.cssj.sakae.pdf.font;

import java.io.IOException;
import java.io.Serializable;

import jp.cssj.sakae.font.Font;
import jp.cssj.sakae.pdf.PdfFragmentOutput;
import jp.cssj.sakae.pdf.XRef;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: PdfFont.java 647 2011-08-28 13:05:54Z miyabe $
 */
public interface PdfFont extends Font, Serializable {
	/**
	 * PDF文書内での識別に使われるフォント名を返します。
	 * 
	 * @return
	 */
	public String getName();

	/**
	 * フォント情報をPDFオブジェクトとして出力します。
	 * 
	 * @param out
	 * @param xref
	 * @throws IOException
	 */
	public void writeTo(PdfFragmentOutput out, XRef xref) throws IOException;
}
