package jp.cssj.sakae.pdf.annot;

import java.io.IOException;
import java.net.URI;

import jp.cssj.sakae.pdf.PdfOutput;
import jp.cssj.sakae.pdf.PdfPageOutput;

/**
 * Linkアノテーションです。
 * 
 * @author <a href="tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: LinkAnnot.java 759 2011-11-13 14:06:17Z miyabe $
 */
public class LinkAnnot extends Annot {
	protected URI uri;

	public URI getURI() {
		return this.uri;
	}

	public void setURI(URI uri) {
		this.uri = uri;
	}

	public void writeTo(PdfOutput out, PdfPageOutput pageOut)
			throws IOException {
		super.writeTo(out, pageOut);

		out.writeName("Border");
		out.startArray();
		out.writeInt(0);
		out.writeInt(0);
		out.writeInt(0);
		out.endArray();
		out.lineBreak();

		out.writeName("Subtype");
		out.writeName("Link");
		out.lineBreak();
		if (uri.toString().startsWith("#")) {
			out.writeName("Dest");
			out.writeText(uri.getFragment());
			out.lineBreak();
		} else {
			out.writeName("A");
			out.startHash();
			out.writeName("S");
			out.writeName("URI");
			out.lineBreak();
			out.writeName("URI");
			out.writeString(uri.toASCIIString());
			out.endHash();
			out.lineBreak();
		}
	}

	public String toString() {
		return "Link: " + this.uri;
	}
}
