package jp.cssj.sakae.pdf.annot;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

import jp.cssj.sakae.pdf.PdfOutput;
import jp.cssj.sakae.pdf.PdfPageOutput;

/**
 * アノテーションです。
 * 
 * @author <a href="tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Annot.java 759 2011-11-13 14:06:17Z miyabe $
 */
public abstract class Annot {
	protected Shape shape;
	protected String contents;

	/**
	 * アノテーションの領域を設定します。 cmオペレータ(あるいはPDF_GCのtransformメソッド)による 座標変換が適用されません。
	 * そのため、shapeに対してはアプリケーションが明示的に座標変換を適用する必要があります。
	 * 
	 * @param shape
	 *            アクティブな範囲です。ただし、PDF1.5以前では、バウンディングボックスが指定範囲となります。
	 */
	public void setShape(Shape shape) {
		this.shape = shape;
	}

	public Shape getShape() {
		return shape;
	}

	public String getContents() {
		return this.contents;
	}

	public void setContents(String contents) {
		this.contents = contents;
	}

	public void writeTo(PdfOutput out, PdfPageOutput pageOut)
			throws IOException {
		out.writeName("Type");
		out.writeName("Annot");
		out.lineBreak();

		// 領域
		double pageHeight = pageOut.getHeight();
		out.writeName("Rect");
		out.startArray();
		Rectangle2D rect = this.getShape().getBounds2D();
		double x = rect.getX();
		double y = rect.getY();
		double width = rect.getWidth();
		double height = rect.getHeight();
		out.writeReal(x);
		out.writeReal(pageHeight - (y + height));
		out.writeReal(x + width);
		out.writeReal(pageHeight - y);
		out.endArray();
		out.lineBreak();

		// 内容
		String contents = this.getContents();
		if (contents != null) {
			out.writeName("Contents");
			out.writeText(contents);
			out.lineBreak();
		}
	}
}
