package jp.cssj.sakae.pdf.action;

import java.io.IOException;

import jp.cssj.sakae.pdf.PdfOutput;
import jp.cssj.sakae.pdf.params.PdfParams;

/**
 * JavaScriptを実行するアクションです。
 * 
 * @author <a href="tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Link.java 647 2011-08-28 13:05:54Z miyabe $
 */
public class JavaScriptAction extends Action {
	protected final String script;
	
	public JavaScriptAction(String script) {
		this.script = script;
	}

	public String getScript() {
		return this.script;
	}

	public void writeTo(PdfOutput out) throws IOException {
		super.writeTo(out);
		if (this.params.getVersion() < PdfParams.VERSION_1_3) {
			throw new UnsupportedOperationException(
					"JavaScript Actionは PDF 1.3 以降で使用できます。");
		}
		out.writeName("S");
		out.writeName("JavaScript");
		out.lineBreak();

		out.writeName("JS");
		out.writeText(this.script);
		out.lineBreak();
	}

	public String toString() {
		return "JavaScript: " + this.script;
	}
}
