package jp.cssj.sakae.pdf;

/**
 * オブジェクトリファレンスです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: ObjectRef.java 647 2011-08-28 13:05:54Z miyabe $
 */
public class ObjectRef {
	public final int objectNumber, generationNumber;

	/**
	 * 
	 * @param objectNumber
	 *            参照のためのオブジェクト番号です。
	 * @param generationNumber
	 *            修正時に使われるジェネレーション番号です。
	 */
	protected ObjectRef(int objectNumber, int generationNumber) {
		this.objectNumber = objectNumber;
		this.generationNumber = generationNumber;
	}

	public boolean equals(Object o) {
		ObjectRef ref = (ObjectRef) o;
		return this.objectNumber == ref.objectNumber
				&& this.generationNumber == ref.generationNumber;
	}
}
