package jp.cssj.sakae.util;

import jp.cssj.sakae.gc.paint.CMYKColor;
import jp.cssj.sakae.gc.paint.Color;
import jp.cssj.sakae.gc.paint.GrayColor;
import jp.cssj.sakae.gc.paint.RGBColor;

public final class ColorUtils {
	private ColorUtils() {
		// unused
	}

	public static GrayColor toGray(Color color) {
		float gray;
		switch (color.getColorType()) {
		case Color.RGB:
			gray = ColorUtils.toGray(color.getComponent(RGBColor.R),
					color.getComponent(RGBColor.G),
					color.getComponent(RGBColor.B));
			break;
		case Color.CMYK:
			gray = ColorUtils.toGray(color.getComponent(CMYKColor.C),
					color.getComponent(CMYKColor.M),
					color.getComponent(CMYKColor.Y),
					color.getComponent(CMYKColor.K));
			break;
		case Color.GRAY:
			gray = color.getComponent(0);
			break;
			
			default:
				throw new IllegalStateException();
		}
		return GrayColor.create(gray);
	}

	public static float toGray(float r, float g, float b) {
		// PDF 6.2.1 による
		return (float) (0.3 * r + 0.59 * g + 0.11 * b);
	}

	public static float toGray(float c, float m, float y, float k) {
		// PDF 6.2.2 による
		return (float) (1.0 - Math.min(1.0, 0.3 * c + 0.59 * m + 0.11 * y + k));
	}
}
